"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemGuideId = exports.getSiemGuideConfig = exports.defaultGuideTranslations = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const siemGuideId = exports.siemGuideId = 'siem';
const defaultGuideTranslations = exports.defaultGuideTranslations = {
  title: i18n.TITLE,
  description: i18n.DESCRIPTION,
  docs: i18n.DOCS,
  steps: {
    add_data: {
      title: i18n.ADD_DATA_TITLE,
      description: i18n.ADD_DATA_DESCRIPTION
    },
    rules: {
      title: i18n.RULES_TITLE,
      description: i18n.RULES_DESCRIPTION,
      manualCompletion: {
        title: i18n.RULES_MANUAL_TITLE,
        description: i18n.RULES_MANUAL_DESCRIPTION
      }
    },
    alertsCases: {
      title: i18n.CASES_TITLE,
      description: i18n.CASES_DESCRIPTION,
      manualCompletion: {
        title: i18n.CASES_MANUAL_TITLE,
        description: i18n.CASES_MANUAL_DESCRIPTION
      }
    }
  }
};
const getSiemGuideConfig = () => ({
  // check each launchDarkly property in case data is misformatted
  title: defaultGuideTranslations.title,
  guideName: 'Security',
  telemetryId: siemGuideId,
  completedGuideRedirectLocation: {
    appID: 'securitySolutionUI',
    path: '/dashboards'
  },
  description: defaultGuideTranslations.description,
  docs: {
    text: defaultGuideTranslations.docs,
    url: 'https://www.elastic.co/guide/en/security/current/ingest-data.html'
  },
  steps: [{
    id: 'add_data',
    title: defaultGuideTranslations.steps.add_data.title,
    description: {
      descriptionText: defaultGuideTranslations.steps.add_data.description,
      linkUrl: 'https://docs.elastic.co/en/integrations/endpoint',
      isLinkExternal: true,
      linkText: i18n.LINK_TEXT
    },
    integration: 'endpoint',
    location: {
      appID: 'integrations',
      path: '/detail/endpoint/overview'
    }
  }, {
    id: 'rules',
    title: defaultGuideTranslations.steps.rules.title,
    description: defaultGuideTranslations.steps.rules.description,
    manualCompletion: {
      title: defaultGuideTranslations.steps.rules.manualCompletion.title,
      description: defaultGuideTranslations.steps.rules.manualCompletion.description
    },
    location: {
      appID: 'securitySolutionUI',
      path: '/rules'
    }
  }, {
    id: 'alertsCases',
    title: defaultGuideTranslations.steps.alertsCases.title,
    description: defaultGuideTranslations.steps.alertsCases.description,
    location: {
      appID: 'securitySolutionUI',
      path: '/alerts'
    },
    manualCompletion: {
      title: defaultGuideTranslations.steps.alertsCases.manualCompletion.title,
      description: defaultGuideTranslations.steps.alertsCases.manualCompletion.description
    }
  }]
});
exports.getSiemGuideConfig = getSiemGuideConfig;