"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPolicySelectionTag = exports.isFilterProcessDescendantsTag = exports.isFilterProcessDescendantsEnabled = exports.isArtifactGlobal = exports.isArtifactByPolicy = exports.getPolicyIdsFromArtifact = exports.getEffectedPolicySelectionByTags = exports.getArtifactTagsByPolicySelection = exports.createExceptionListItemForCreate = void 0;
var _uuid = require("uuid");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ID_START_POSITION = _constants.BY_POLICY_ARTIFACT_TAG_PREFIX.length;
const isArtifactGlobal = item => {
  var _item$tags;
  return ((_item$tags = item.tags) !== null && _item$tags !== void 0 ? _item$tags : []).includes(_constants.GLOBAL_ARTIFACT_TAG);
};
exports.isArtifactGlobal = isArtifactGlobal;
const isArtifactByPolicy = item => {
  return !isArtifactGlobal(item);
};
exports.isArtifactByPolicy = isArtifactByPolicy;
const getPolicyIdsFromArtifact = item => {
  var _item$tags2;
  const policyIds = [];
  const tags = (_item$tags2 = item.tags) !== null && _item$tags2 !== void 0 ? _item$tags2 : [];
  for (const tag of tags) {
    if (tag !== _constants.GLOBAL_ARTIFACT_TAG && tag.startsWith(_constants.BY_POLICY_ARTIFACT_TAG_PREFIX)) {
      policyIds.push(tag.substring(POLICY_ID_START_POSITION));
    }
  }
  return policyIds;
};
exports.getPolicyIdsFromArtifact = getPolicyIdsFromArtifact;
const isPolicySelectionTag = tag => tag.startsWith(_constants.BY_POLICY_ARTIFACT_TAG_PREFIX) || tag === _constants.GLOBAL_ARTIFACT_TAG;

/**
 * Return a list of artifact policy tags based on a current
 * selection by the EffectedPolicySelection component.
 */
exports.isPolicySelectionTag = isPolicySelectionTag;
const getArtifactTagsByPolicySelection = selection => {
  if (selection.isGlobal) {
    return [_constants.GLOBAL_ARTIFACT_TAG];
  }
  return selection.selected.map(policy => {
    return `${_constants.BY_POLICY_ARTIFACT_TAG_PREFIX}${policy.id}`;
  });
};

/**
 * Given a list of an Exception item tags it will return
 * the parsed policies from it.
 *
 * Policy tags follow the pattern `policy:id`
 * non policy tags will be ignored.
 */
exports.getArtifactTagsByPolicySelection = getArtifactTagsByPolicySelection;
const getEffectedPolicySelectionByTags = (tags, policies) => {
  if (tags.find(tag => tag === _constants.GLOBAL_ARTIFACT_TAG)) {
    return {
      isGlobal: true,
      selected: []
    };
  }
  const selected = tags.reduce((acc, tag) => {
    // edge case: a left over tag with a non-existed policy
    // will be removed by verifying the policy exists
    const id = tag.split(':')[1];
    const foundPolicy = policies.find(policy => policy.id === id);
    if (foundPolicy !== undefined) {
      acc.push(foundPolicy);
    }
    return acc;
  }, []);
  return {
    isGlobal: false,
    selected
  };
};
exports.getEffectedPolicySelectionByTags = getEffectedPolicySelectionByTags;
const isFilterProcessDescendantsEnabled = item => {
  var _item$tags3;
  return ((_item$tags3 = item.tags) !== null && _item$tags3 !== void 0 ? _item$tags3 : []).includes(_constants.FILTER_PROCESS_DESCENDANTS_TAG);
};
exports.isFilterProcessDescendantsEnabled = isFilterProcessDescendantsEnabled;
const isFilterProcessDescendantsTag = tag => tag === _constants.FILTER_PROCESS_DESCENDANTS_TAG;
exports.isFilterProcessDescendantsTag = isFilterProcessDescendantsTag;
const createExceptionListItemForCreate = listId => {
  return {
    comments: [],
    description: '',
    entries: [],
    item_id: undefined,
    list_id: listId,
    meta: {
      temporaryUuid: (0, _uuid.v4)()
    },
    name: '',
    namespace_type: 'agnostic',
    tags: [_constants.GLOBAL_ARTIFACT_TAG],
    type: 'simple',
    os_types: ['windows']
  };
};
exports.createExceptionListItemForCreate = createExceptionListItemForCreate;