"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryIndexPattern = exports.policyIndexPattern = exports.metadataTransformPrefix = exports.metadataIndexPattern = exports.metadataCurrentIndexPattern = exports.failedFleetActionErrorCode = exports.eventsIndexPattern = exports.alertsIndexPattern = exports.WORKFLOW_INSIGHTS_UPDATE_ROUTE = exports.WORKFLOW_INSIGHTS_ROUTE = exports.UPLOAD_ROUTE = exports.UNISOLATE_HOST_ROUTE_V2 = exports.UNISOLATE_HOST_ROUTE = exports.SUSPEND_PROCESS_ROUTE = exports.SUPPORTED_HOST_OS_TYPE = exports.SUGGESTIONS_ROUTE = exports.SUGGESTIONS_INTERNAL_ROUTE = exports.SCAN_ROUTE = exports.RUN_SCRIPT_ROUTE = exports.PROTECTION_UPDATES_NOTE_ROUTE = exports.POLICY_RESPONSE_INDEX = exports.METADATA_UNITED_TRANSFORM_V2 = exports.METADATA_UNITED_TRANSFORM = exports.METADATA_UNITED_INDEX = exports.METADATA_TRANSFORMS_STATUS_ROUTE = exports.METADATA_TRANSFORMS_STATUS_INTERNAL_ROUTE = exports.METADATA_TRANSFORMS_PATTERN_V2 = exports.METADATA_TRANSFORMS_PATTERN = exports.METADATA_DATASTREAM = exports.METADATA_CURRENT_TRANSFORM_V2 = exports.KILL_PROCESS_ROUTE = exports.ISOLATE_HOST_ROUTE_V2 = exports.ISOLATE_HOST_ROUTE = exports.HOST_METADATA_LIST_ROUTE = exports.HOST_METADATA_GET_ROUTE = exports.GET_PROCESSES_ROUTE = exports.GET_FILE_ROUTE = exports.FILE_STORAGE_METADATA_INDEX = exports.FILE_STORAGE_DATA_INDEX = exports.FILE_EVENTS_INDEX_PATTERN = exports.EXECUTE_ROUTE = exports.ENDPOINT_SEARCH_STRATEGY = exports.ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY = exports.ENDPOINT_HEARTBEAT_INDEX_PATTERN = exports.ENDPOINT_HEARTBEAT_INDEX = exports.ENDPOINT_FIELDS_SEARCH_STRATEGY = exports.ENDPOINT_ERROR_CODES = exports.ENDPOINT_DEFAULT_SORT_FIELD = exports.ENDPOINT_DEFAULT_SORT_DIRECTION = exports.ENDPOINT_DEFAULT_PAGE_SIZE = exports.ENDPOINT_DEFAULT_PAGE = exports.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = exports.ENDPOINT_ACTION_RESPONSES_INDEX = exports.ENDPOINT_ACTION_RESPONSES_DS = exports.ENDPOINT_ACTION_LOG_ROUTE = exports.ENDPOINT_ACTIONS_INDEX = exports.ENDPOINT_ACTIONS_DS = exports.CUSTOM_SCRIPTS_ROUTE = exports.BASE_WORKFLOW_INSIGHTS_ROUTE = exports.BASE_POLICY_ROUTE = exports.BASE_POLICY_RESPONSE_ROUTE = exports.BASE_INTERNAL_ENDPOINT_ROUTE = exports.BASE_INTERNAL_ENDPOINT_ACTION_ROUTE = exports.BASE_ENDPOINT_ROUTE = exports.BASE_ENDPOINT_ACTION_ROUTE = exports.AGENT_STATUS_ROUTE = exports.AGENT_POLICY_SUMMARY_ROUTE = exports.ACTION_STATUS_ROUTE = exports.ACTION_STATE_ROUTE = exports.ACTION_DETAILS_ROUTE = exports.ACTION_AGENT_FILE_INFO_ROUTE = exports.ACTION_AGENT_FILE_DOWNLOAD_ROUTE = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** endpoint data streams that are used for host isolation  */

/** for index patterns `.logs-endpoint.actions-* and .logs-endpoint.action.responses-*`*/
const ENDPOINT_ACTIONS_DS = exports.ENDPOINT_ACTIONS_DS = '.logs-endpoint.actions';
const ENDPOINT_ACTIONS_INDEX = exports.ENDPOINT_ACTIONS_INDEX = `${ENDPOINT_ACTIONS_DS}-default`;
const ENDPOINT_ACTION_RESPONSES_DS = exports.ENDPOINT_ACTION_RESPONSES_DS = '.logs-endpoint.action.responses';
const ENDPOINT_ACTION_RESPONSES_INDEX = exports.ENDPOINT_ACTION_RESPONSES_INDEX = `${ENDPOINT_ACTION_RESPONSES_DS}-default`;
// search in all namespaces and not only in default
const ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = exports.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = `${ENDPOINT_ACTION_RESPONSES_DS}-*`;
const eventsIndexPattern = exports.eventsIndexPattern = 'logs-endpoint.events.*';
const FILE_EVENTS_INDEX_PATTERN = exports.FILE_EVENTS_INDEX_PATTERN = 'logs-endpoint.events.file-*';
const alertsIndexPattern = exports.alertsIndexPattern = 'logs-endpoint.alerts-*';

// metadata datastream
const METADATA_DATASTREAM = exports.METADATA_DATASTREAM = 'metrics-endpoint.metadata-default';

/** index pattern for the data source index (data stream) that the Endpoint streams documents to */
const metadataIndexPattern = exports.metadataIndexPattern = 'metrics-endpoint.metadata-*';

/** index that the metadata transform writes to (destination) and that is used by endpoint APIs */
const metadataCurrentIndexPattern = exports.metadataCurrentIndexPattern = 'metrics-endpoint.metadata_current_*';

// endpoint package V2 has an additional prefix in the transform names
const PACKAGE_V2_PREFIX = 'logs-';

/** The metadata Transform Name prefix with NO (package) version) */
const metadataTransformPrefix = exports.metadataTransformPrefix = 'endpoint.metadata_current-default';
const METADATA_CURRENT_TRANSFORM_V2 = exports.METADATA_CURRENT_TRANSFORM_V2 = `${PACKAGE_V2_PREFIX}${metadataTransformPrefix}`;

// metadata transforms pattern for matching all metadata transform ids
const METADATA_TRANSFORMS_PATTERN = exports.METADATA_TRANSFORMS_PATTERN = 'endpoint.metadata_*';
const METADATA_TRANSFORMS_PATTERN_V2 = exports.METADATA_TRANSFORMS_PATTERN_V2 = `${PACKAGE_V2_PREFIX}${METADATA_TRANSFORMS_PATTERN}`;

// united metadata transform id
const METADATA_UNITED_TRANSFORM = exports.METADATA_UNITED_TRANSFORM = 'endpoint.metadata_united-default';
const METADATA_UNITED_TRANSFORM_V2 = exports.METADATA_UNITED_TRANSFORM_V2 = `${PACKAGE_V2_PREFIX}${METADATA_UNITED_TRANSFORM}`;

// united metadata transform destination index
const METADATA_UNITED_INDEX = exports.METADATA_UNITED_INDEX = '.metrics-endpoint.metadata_united_default';
const POLICY_RESPONSE_INDEX = exports.POLICY_RESPONSE_INDEX = 'metrics-endpoint.policy-default';
const policyIndexPattern = exports.policyIndexPattern = 'metrics-endpoint.policy-*';
const telemetryIndexPattern = exports.telemetryIndexPattern = 'metrics-endpoint.telemetry-*';
const ENDPOINT_HEARTBEAT_INDEX = exports.ENDPOINT_HEARTBEAT_INDEX = '.logs-endpoint.heartbeat-default';
const ENDPOINT_HEARTBEAT_INDEX_PATTERN = exports.ENDPOINT_HEARTBEAT_INDEX_PATTERN = '.logs-endpoint.heartbeat-*';

// File storage indexes supporting endpoint Upload/download
const FILE_STORAGE_METADATA_INDEX = exports.FILE_STORAGE_METADATA_INDEX = (0, _common.getFileMetadataIndexName)('endpoint');
const FILE_STORAGE_DATA_INDEX = exports.FILE_STORAGE_DATA_INDEX = (0, _common.getFileDataIndexName)('endpoint');

// Location from where all Endpoint related APIs are mounted
const BASE_ENDPOINT_ROUTE = exports.BASE_ENDPOINT_ROUTE = '/api/endpoint';
const BASE_INTERNAL_ENDPOINT_ROUTE = exports.BASE_INTERNAL_ENDPOINT_ROUTE = `/internal${BASE_ENDPOINT_ROUTE}`;

// Endpoint API routes
const HOST_METADATA_LIST_ROUTE = exports.HOST_METADATA_LIST_ROUTE = `${BASE_ENDPOINT_ROUTE}/metadata`;
const HOST_METADATA_GET_ROUTE = exports.HOST_METADATA_GET_ROUTE = `${HOST_METADATA_LIST_ROUTE}/{id}`;

/** @deprecated public route, use {@link METADATA_TRANSFORMS_STATUS_INTERNAL_ROUTE} internal route  */
const METADATA_TRANSFORMS_STATUS_ROUTE = exports.METADATA_TRANSFORMS_STATUS_ROUTE = `${BASE_ENDPOINT_ROUTE}/metadata/transforms`;
const METADATA_TRANSFORMS_STATUS_INTERNAL_ROUTE = exports.METADATA_TRANSFORMS_STATUS_INTERNAL_ROUTE = `${BASE_INTERNAL_ENDPOINT_ROUTE}/metadata/transforms`;
const BASE_POLICY_RESPONSE_ROUTE = exports.BASE_POLICY_RESPONSE_ROUTE = `${BASE_ENDPOINT_ROUTE}/policy_response`;
const BASE_POLICY_ROUTE = exports.BASE_POLICY_ROUTE = `${BASE_ENDPOINT_ROUTE}/policy`;
const AGENT_POLICY_SUMMARY_ROUTE = exports.AGENT_POLICY_SUMMARY_ROUTE = `${BASE_POLICY_ROUTE}/summaries`;
const PROTECTION_UPDATES_NOTE_ROUTE = exports.PROTECTION_UPDATES_NOTE_ROUTE = `${BASE_ENDPOINT_ROUTE}/protection_updates_note/{package_policy_id}`;

/** Suggestions routes */
/** @deprecated public route, use {@link SUGGESTIONS_INTERNAL_ROUTE} internal route  */
const SUGGESTIONS_ROUTE = exports.SUGGESTIONS_ROUTE = `${BASE_ENDPOINT_ROUTE}/suggestions/{suggestion_type}`;
const SUGGESTIONS_INTERNAL_ROUTE = exports.SUGGESTIONS_INTERNAL_ROUTE = `${BASE_INTERNAL_ENDPOINT_ROUTE}/suggestions/{suggestion_type}`;

/**
 * Action Response Routes
 */

/** @deprecated use `ISOLATE_HOST_ROUTE_V2` instead */
const ISOLATE_HOST_ROUTE = exports.ISOLATE_HOST_ROUTE = `${BASE_ENDPOINT_ROUTE}/isolate`;
/** @deprecated use `ISOLATE_HOST_ROUTE_V2` instead */
const UNISOLATE_HOST_ROUTE = exports.UNISOLATE_HOST_ROUTE = `${BASE_ENDPOINT_ROUTE}/unisolate`;

/** Base Actions route. Used to get a list of all actions and is root to other action related routes */
const BASE_ENDPOINT_ACTION_ROUTE = exports.BASE_ENDPOINT_ACTION_ROUTE = `${BASE_ENDPOINT_ROUTE}/action`;
const BASE_INTERNAL_ENDPOINT_ACTION_ROUTE = exports.BASE_INTERNAL_ENDPOINT_ACTION_ROUTE = `/internal${BASE_ENDPOINT_ACTION_ROUTE}`;
const ISOLATE_HOST_ROUTE_V2 = exports.ISOLATE_HOST_ROUTE_V2 = `${BASE_ENDPOINT_ACTION_ROUTE}/isolate`;
const UNISOLATE_HOST_ROUTE_V2 = exports.UNISOLATE_HOST_ROUTE_V2 = `${BASE_ENDPOINT_ACTION_ROUTE}/unisolate`;
const GET_PROCESSES_ROUTE = exports.GET_PROCESSES_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/running_procs`;
const KILL_PROCESS_ROUTE = exports.KILL_PROCESS_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/kill_process`;
const SUSPEND_PROCESS_ROUTE = exports.SUSPEND_PROCESS_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/suspend_process`;
const GET_FILE_ROUTE = exports.GET_FILE_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/get_file`;
const EXECUTE_ROUTE = exports.EXECUTE_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/execute`;
const UPLOAD_ROUTE = exports.UPLOAD_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/upload`;
const SCAN_ROUTE = exports.SCAN_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/scan`;
const RUN_SCRIPT_ROUTE = exports.RUN_SCRIPT_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/run_script`;
const CUSTOM_SCRIPTS_ROUTE = exports.CUSTOM_SCRIPTS_ROUTE = `${BASE_INTERNAL_ENDPOINT_ACTION_ROUTE}/custom_scripts`;

/** Endpoint Actions Routes */
const ENDPOINT_ACTION_LOG_ROUTE = exports.ENDPOINT_ACTION_LOG_ROUTE = `${BASE_ENDPOINT_ROUTE}/action_log/{agent_id}`;
const ACTION_STATUS_ROUTE = exports.ACTION_STATUS_ROUTE = `${BASE_ENDPOINT_ROUTE}/action_status`;
const ACTION_DETAILS_ROUTE = exports.ACTION_DETAILS_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/{action_id}`;
const ACTION_AGENT_FILE_INFO_ROUTE = exports.ACTION_AGENT_FILE_INFO_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/{action_id}/file/{file_id}`;
const ACTION_AGENT_FILE_DOWNLOAD_ROUTE = exports.ACTION_AGENT_FILE_DOWNLOAD_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/{action_id}/file/{file_id}/download`;
const ACTION_STATE_ROUTE = exports.ACTION_STATE_ROUTE = `${BASE_ENDPOINT_ACTION_ROUTE}/state`;

/** Endpoint Agent Routes */
const AGENT_STATUS_ROUTE = exports.AGENT_STATUS_ROUTE = `/internal${BASE_ENDPOINT_ROUTE}/agent_status`;
const failedFleetActionErrorCode = exports.failedFleetActionErrorCode = '424';
const ENDPOINT_DEFAULT_PAGE = exports.ENDPOINT_DEFAULT_PAGE = 0;
const ENDPOINT_DEFAULT_PAGE_SIZE = exports.ENDPOINT_DEFAULT_PAGE_SIZE = 10;
const ENDPOINT_DEFAULT_SORT_FIELD = exports.ENDPOINT_DEFAULT_SORT_FIELD = _types.EndpointSortableField.ENROLLED_AT;
const ENDPOINT_DEFAULT_SORT_DIRECTION = exports.ENDPOINT_DEFAULT_SORT_DIRECTION = 'desc';
const ENDPOINT_ERROR_CODES = exports.ENDPOINT_ERROR_CODES = {
  ES_CONNECTION_ERROR: -272,
  OUTPUT_SERVER_ERROR: -273
};
const ENDPOINT_FIELDS_SEARCH_STRATEGY = exports.ENDPOINT_FIELDS_SEARCH_STRATEGY = 'endpointFields';
const ENDPOINT_SEARCH_STRATEGY = exports.ENDPOINT_SEARCH_STRATEGY = 'endpointSearchStrategy';

/** Search strategy keys */
const ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY = exports.ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY = 'endpointPackagePoliciesStatsStrategy';

/** The list of OS types that support. Value usually found in ECS `host.os.type` */
const SUPPORTED_HOST_OS_TYPE = exports.SUPPORTED_HOST_OS_TYPE = Object.freeze(['macos', 'windows', 'linux']);
/**
 * Workflow Insights
 */

const BASE_WORKFLOW_INSIGHTS_ROUTE = exports.BASE_WORKFLOW_INSIGHTS_ROUTE = `/workflow_insights`;
const WORKFLOW_INSIGHTS_ROUTE = exports.WORKFLOW_INSIGHTS_ROUTE = `${BASE_INTERNAL_ENDPOINT_ROUTE}${BASE_WORKFLOW_INSIGHTS_ROUTE}`;
const WORKFLOW_INSIGHTS_UPDATE_ROUTE = exports.WORKFLOW_INSIGHTS_UPDATE_ROUTE = `${WORKFLOW_INSIGHTS_ROUTE}/{insightId}`;