"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleToAlertResponseAction = exports.transformRuleToAlertAction = exports.transformNormalizedRuleToAlertAction = exports.transformAlertToRuleSystemAction = exports.transformAlertToRuleResponseAction = exports.transformAlertToRuleAction = exports.transformAlertToNormalizedRuleAction = void 0;
var _rule_response_actions = require("../api/detection_engine/model/rule_response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRuleToAlertAction = ({
  group,
  id,
  action_type_id: actionTypeId,
  params,
  uuid,
  frequency,
  alerts_filter: alertsFilter
}) => ({
  id,
  params: params,
  actionTypeId,
  ...(alertsFilter && {
    alertsFilter: alertsFilter
  }),
  ...(uuid && {
    uuid
  }),
  ...(frequency && {
    frequency
  }),
  ...(group && {
    group
  })
});
exports.transformRuleToAlertAction = transformRuleToAlertAction;
const transformAlertToRuleAction = ({
  group,
  id,
  actionTypeId,
  params,
  uuid,
  frequency,
  alertsFilter
}) => ({
  id,
  params,
  action_type_id: actionTypeId,
  ...(alertsFilter && {
    alerts_filter: alertsFilter
  }),
  ...(uuid && {
    uuid
  }),
  ...(frequency && {
    frequency
  }),
  ...(group && {
    group
  })
});
exports.transformAlertToRuleAction = transformAlertToRuleAction;
const transformAlertToRuleSystemAction = ({
  id,
  actionTypeId,
  params,
  uuid
}) => ({
  id,
  params,
  action_type_id: actionTypeId,
  ...(uuid && {
    uuid
  })
});
exports.transformAlertToRuleSystemAction = transformAlertToRuleSystemAction;
const transformNormalizedRuleToAlertAction = ({
  group,
  id,
  params,
  frequency,
  alerts_filter: alertsFilter
}) => ({
  id,
  params: params,
  ...(alertsFilter && {
    // We use "unknown" as the alerts filter type which is stricter than the one
    // used in the alerting plugin (what they use is essentially "any"). So we
    // have to to cast here
    alertsFilter: alertsFilter
  }),
  ...(frequency && {
    frequency
  }),
  ...(group && {
    group
  })
});
exports.transformNormalizedRuleToAlertAction = transformNormalizedRuleToAlertAction;
const transformAlertToNormalizedRuleAction = ({
  group,
  id,
  params,
  frequency,
  alertsFilter
}) => ({
  group,
  id,
  params,
  ...(alertsFilter && {
    alerts_filter: alertsFilter
  }),
  ...(frequency && {
    frequency
  })
});
exports.transformAlertToNormalizedRuleAction = transformAlertToNormalizedRuleAction;
const transformRuleToAlertResponseAction = ({
  action_type_id: actionTypeId,
  params
}) => {
  if (actionTypeId === _rule_response_actions.ResponseActionTypesEnum['.osquery']) {
    const {
      saved_query_id: savedQueryId,
      ecs_mapping: ecsMapping,
      pack_id: packId,
      ...rest
    } = params;
    return {
      params: {
        ...rest,
        savedQueryId,
        ecsMapping,
        packId
      },
      actionTypeId
    };
  }
  return {
    params,
    actionTypeId
  };
};
exports.transformRuleToAlertResponseAction = transformRuleToAlertResponseAction;
const transformAlertToRuleResponseAction = ({
  actionTypeId,
  params
}) => {
  if (actionTypeId === _rule_response_actions.ResponseActionTypesEnum['.osquery']) {
    const {
      savedQueryId,
      ecsMapping,
      packId,
      ...rest
    } = params;
    return {
      params: {
        ...rest,
        saved_query_id: savedQueryId,
        ecs_mapping: ecsMapping,
        pack_id: packId
      },
      action_type_id: actionTypeId
    };
  }
  return {
    params,
    action_type_id: actionTypeId
  };
};
exports.transformAlertToRuleResponseAction = transformAlertToRuleResponseAction;