"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRiskScoreBySeverity = exports.SUPPRESSIBLE_ALERT_RULES_GA = exports.SUPPRESSIBLE_ALERT_RULES = exports.SECURITY_AI_PROMPTS_PACKAGE_NAME = exports.RULE_PREVIEW_INVOCATION_COUNT = exports.RULE_PREVIEW_INTERVAL = exports.RULE_PREVIEW_FROM = exports.RISK_SCORE_MEDIUM = exports.RISK_SCORE_LOW = exports.RISK_SCORE_HIGH = exports.RISK_SCORE_CRITICAL = exports.PREBUILT_RULES_PACKAGE_NAME = exports.MINIMUM_LICENSE_FOR_SUPPRESSION = exports.ENDPOINT_PACKAGE_NAME = exports.ELASTIC_SECURITY_RULE_ID = exports.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RULE_PREVIEW_INVOCATION_COUNT = exports.RULE_PREVIEW_INVOCATION_COUNT = /*#__PURE__*/function (RULE_PREVIEW_INVOCATION_COUNT) {
  RULE_PREVIEW_INVOCATION_COUNT[RULE_PREVIEW_INVOCATION_COUNT["HOUR"] = 12] = "HOUR";
  RULE_PREVIEW_INVOCATION_COUNT[RULE_PREVIEW_INVOCATION_COUNT["DAY"] = 24] = "DAY";
  RULE_PREVIEW_INVOCATION_COUNT[RULE_PREVIEW_INVOCATION_COUNT["WEEK"] = 168] = "WEEK";
  RULE_PREVIEW_INVOCATION_COUNT[RULE_PREVIEW_INVOCATION_COUNT["MONTH"] = 30] = "MONTH";
  return RULE_PREVIEW_INVOCATION_COUNT;
}({});
let RULE_PREVIEW_INTERVAL = exports.RULE_PREVIEW_INTERVAL = /*#__PURE__*/function (RULE_PREVIEW_INTERVAL) {
  RULE_PREVIEW_INTERVAL["HOUR"] = "5m";
  RULE_PREVIEW_INTERVAL["DAY"] = "1h";
  RULE_PREVIEW_INTERVAL["WEEK"] = "1h";
  RULE_PREVIEW_INTERVAL["MONTH"] = "1d";
  return RULE_PREVIEW_INTERVAL;
}({});
let RULE_PREVIEW_FROM = exports.RULE_PREVIEW_FROM = /*#__PURE__*/function (RULE_PREVIEW_FROM) {
  RULE_PREVIEW_FROM["HOUR"] = "now-6m";
  RULE_PREVIEW_FROM["DAY"] = "now-65m";
  RULE_PREVIEW_FROM["WEEK"] = "now-65m";
  RULE_PREVIEW_FROM["MONTH"] = "now-25h";
  return RULE_PREVIEW_FROM;
}({});
const PREBUILT_RULES_PACKAGE_NAME = exports.PREBUILT_RULES_PACKAGE_NAME = 'security_detection_engine';
const ENDPOINT_PACKAGE_NAME = exports.ENDPOINT_PACKAGE_NAME = 'endpoint';
const SECURITY_AI_PROMPTS_PACKAGE_NAME = exports.SECURITY_AI_PROMPTS_PACKAGE_NAME = 'security_ai_prompts';

/**
 * Rule signature id (`rule.rule_id`) of the prebuilt "Endpoint Security" rule.
 */
const ELASTIC_SECURITY_RULE_ID = exports.ELASTIC_SECURITY_RULE_ID = '9a1a2dae-0b5f-4c3d-8305-a268d404c306';
const DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY = exports.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY = 'suppress';
const MINIMUM_LICENSE_FOR_SUPPRESSION = exports.MINIMUM_LICENSE_FOR_SUPPRESSION = 'platinum';
const SUPPRESSIBLE_ALERT_RULES = exports.SUPPRESSIBLE_ALERT_RULES = ['threshold', 'esql', 'saved_query', 'query', 'new_terms', 'threat_match', 'eql', 'machine_learning'];
const SUPPRESSIBLE_ALERT_RULES_GA = exports.SUPPRESSIBLE_ALERT_RULES_GA = ['threshold', 'esql', 'saved_query', 'query', 'new_terms', 'threat_match', 'machine_learning', 'eql'];
const RISK_SCORE_LOW = exports.RISK_SCORE_LOW = 21;
const RISK_SCORE_MEDIUM = exports.RISK_SCORE_MEDIUM = 47;
const RISK_SCORE_HIGH = exports.RISK_SCORE_HIGH = 73;
const RISK_SCORE_CRITICAL = exports.RISK_SCORE_CRITICAL = 99;
const defaultRiskScoreBySeverity = exports.defaultRiskScoreBySeverity = {
  low: RISK_SCORE_LOW,
  medium: RISK_SCORE_MEDIUM,
  high: RISK_SCORE_HIGH,
  critical: RISK_SCORE_CRITICAL
};