"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTags = exports.AlertTag = exports.AlertStatusEnum = exports.AlertStatus = exports.AlertIds = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("./primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Shared Alert Primitives Schema
 *   version: not applicable
 */

/**
 * A list of alerts ids.
 */

const AlertIds = exports.AlertIds = _zod.z.array(_primitives.NonEmptyString).min(1);
const AlertTag = exports.AlertTag = _primitives.NonEmptyString;
const AlertTags = exports.AlertTags = _zod.z.array(AlertTag);
const AlertStatus = exports.AlertStatus = _zod.z.enum(['open', 'closed', 'acknowledged', 'in-progress']);
const AlertStatusEnum = exports.AlertStatusEnum = AlertStatus.enum;