"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoresCalculationResponse = void 0;
var _zod = require("@kbn/zod");
var _common = require("../common/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: RiskScoresCalculation types
 *   version: 1
 */

const RiskScoresCalculationResponse = exports.RiskScoresCalculationResponse = _zod.z.object({
  /**
   * Used to obtain the next "page" of risk scores. See also the `after_keys` key in a risk scores request. If this key is empty, the calculation is complete.
   */
  after_keys: _common.AfterKeys,
  /**
   * A list of errors encountered during the calculation.
   */
  errors: _zod.z.array(_zod.z.string()),
  /**
   * The number of risk scores persisted to elasticsearch.
   */
  scores_written: _zod.z.number(),
  scores: _zod.z.object({
    /**
     * A list of host risk scores
     */
    host: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of user risk scores
     */
    user: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of service risk scores
     */
    service: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of universal risk scores
     */
    universal: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * If 'wait_for' the request will wait for the index refresh.
     */
    refresh: _zod.z.literal('wait_for').optional()
  }).optional()
});