"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserEntity = exports.ServiceEntity = exports.HostEntity = exports.EntityInternal = exports.Entity = void 0;
var _zod = require("@kbn/zod");
var _common = require("../../common/common.gen");
var _common2 = require("../../asset_criticality/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Entities Schemas
 *   version: 1
 */

const UserEntity = exports.UserEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: _zod.z.object({
    name: _zod.z.string(),
    source: _zod.z.string()
  }),
  user: _zod.z.object({
    full_name: _zod.z.array(_zod.z.string()).optional(),
    domain: _zod.z.array(_zod.z.string()).optional(),
    roles: _zod.z.array(_zod.z.string()).optional(),
    name: _zod.z.string(),
    id: _zod.z.array(_zod.z.string()).optional(),
    email: _zod.z.array(_zod.z.string()).optional(),
    hash: _zod.z.array(_zod.z.string()).optional(),
    risk: _common.EntityRiskScoreRecord.optional()
  }),
  asset: _zod.z.object({
    criticality: _common2.AssetCriticalityLevel
  }).optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).optional()
});
const HostEntity = exports.HostEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: _zod.z.object({
    name: _zod.z.string(),
    source: _zod.z.string()
  }),
  host: _zod.z.object({
    hostname: _zod.z.array(_zod.z.string()).optional(),
    domain: _zod.z.array(_zod.z.string()).optional(),
    ip: _zod.z.array(_zod.z.string()).optional(),
    name: _zod.z.string(),
    id: _zod.z.array(_zod.z.string()).optional(),
    type: _zod.z.array(_zod.z.string()).optional(),
    mac: _zod.z.array(_zod.z.string()).optional(),
    architecture: _zod.z.array(_zod.z.string()).optional(),
    risk: _common.EntityRiskScoreRecord.optional()
  }),
  asset: _zod.z.object({
    criticality: _common2.AssetCriticalityLevel
  }).optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).optional()
});
const ServiceEntity = exports.ServiceEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: _zod.z.object({
    name: _zod.z.string(),
    source: _zod.z.string()
  }),
  service: _zod.z.object({
    name: _zod.z.string(),
    risk: _common.EntityRiskScoreRecord.optional()
  }),
  asset: _zod.z.object({
    criticality: _common2.AssetCriticalityLevel
  }).optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).optional()
});
const EntityInternal = exports.EntityInternal = _zod.z.union([UserEntity, HostEntity, ServiceEntity]);
const Entity = exports.Entity = EntityInternal;