"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldUpgradeSpecifier = exports.UpgradeSpecificRulesRequest = exports.UpgradeConflictSkipReason = exports.UpgradeConflictResolutionEnum = exports.UpgradeConflictResolution = exports.UpgradeAllRulesRequest = exports.SkippedRuleUpgrade = exports.SkipRuleUpgradeReasonEnum = exports.SkipRuleUpgradeReason = exports.RuleUpgradeSpecifier = exports.RuleUpToDateSkipReason = exports.RuleFieldsToUpgrade = exports.PickVersionValuesEnum = exports.PickVersionValues = exports.PerformRuleUpgradeResponseBody = exports.PerformRuleUpgradeRequestBody = exports.NON_UPGRADEABLE_DIFFABLE_FIELDS = exports.ModeEnum = exports.Mode = exports.FIELDS_TO_UPGRADE_TO_TARGET_VERSION = exports.FIELDS_TO_UPGRADE_TO_CURRENT_VERSION = exports.DiffableUpgradableFields = exports.DiffableFieldsToOmit = void 0;
var _zod = require("@kbn/zod");
var _lodash = require("lodash");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
var _model = require("../model");
var _model2 = require("../../model");
var _prebuilt_rules_filter = require("../common/prebuilt_rules_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Mode = exports.Mode = _zod.z.enum(['ALL_RULES', 'SPECIFIC_RULES']);
const ModeEnum = exports.ModeEnum = Mode.enum;
const PickVersionValues = exports.PickVersionValues = _zod.z.enum(['BASE', 'CURRENT', 'TARGET', 'MERGED']);
const PickVersionValuesEnum = exports.PickVersionValuesEnum = PickVersionValues.enum;

// Specific handling of special fields according to:
// https://github.com/elastic/kibana/issues/186544
const FIELDS_TO_UPGRADE_TO_CURRENT_VERSION = exports.FIELDS_TO_UPGRADE_TO_CURRENT_VERSION = ['enabled', 'exceptions_list', 'actions', 'throttle', 'response_actions', 'meta', 'output_index', 'namespace', 'alias_purpose', 'alias_target_id', 'outcome', 'concurrent_searches', 'items_per_search'];
const FIELDS_TO_UPGRADE_TO_TARGET_VERSION = exports.FIELDS_TO_UPGRADE_TO_TARGET_VERSION = ['type', 'rule_id', 'version', 'author', 'license'];

// Fields which are part of DiffableRule but are not upgradeable
// and need to be omittted from the DiffableUpgradableFields
const NON_UPGRADEABLE_DIFFABLE_FIELDS = exports.NON_UPGRADEABLE_DIFFABLE_FIELDS = ['type', 'rule_id', 'version'];
// This transformation is needed to have Zod's `omit` accept the rule fields that need to be omitted
const DiffableFieldsToOmit = exports.DiffableFieldsToOmit = NON_UPGRADEABLE_DIFFABLE_FIELDS.reduce((acc, field) => {
  return {
    ...acc,
    [field]: true
  };
}, {});

/**
 * Fields upgradable by the /upgrade/_perform endpoint.
 * Specific fields are omitted because they are not upgradeable, and
 * handled under the hood by endpoint logic.
 * See: https://github.com/elastic/kibana/issues/186544
 */

const DiffableUpgradableFields = exports.DiffableUpgradableFields = _model.DiffableAllFields.omit(DiffableFieldsToOmit);
const fieldUpgradeSpecifier = fieldSchema => _zod.z.discriminatedUnion('pick_version', [_zod.z.object({
  pick_version: PickVersionValues
}).strict(), _zod.z.object({
  pick_version: _zod.z.literal('RESOLVED'),
  resolved_value: fieldSchema
}).strict()]);
exports.fieldUpgradeSpecifier = fieldUpgradeSpecifier;
const RuleFieldsToUpgrade = exports.RuleFieldsToUpgrade = _zod.z.object((0, _lodash.mapValues)(DiffableUpgradableFields.shape, fieldSchema => {
  return fieldUpgradeSpecifier(fieldSchema).optional();
})).strict();
const RuleUpgradeSpecifier = exports.RuleUpgradeSpecifier = _zod.z.object({
  rule_id: _model2.RuleSignatureId,
  revision: _zod.z.number(),
  version: _model2.RuleVersion,
  pick_version: PickVersionValues.optional(),
  // Fields that can be customized during the upgrade workflow
  // as decided in: https://github.com/elastic/kibana/issues/186544
  fields: RuleFieldsToUpgrade.optional()
});
const UpgradeConflictResolution = exports.UpgradeConflictResolution = _zod.z.enum(['SKIP', 'UPGRADE_SOLVABLE']);
const UpgradeConflictResolutionEnum = exports.UpgradeConflictResolutionEnum = UpgradeConflictResolution.enum;
const UpgradeSpecificRulesRequest = exports.UpgradeSpecificRulesRequest = _zod.z.object({
  mode: _zod.z.literal('SPECIFIC_RULES'),
  rules: _zod.z.array(RuleUpgradeSpecifier).min(1),
  pick_version: PickVersionValues.optional(),
  on_conflict: UpgradeConflictResolution.optional(),
  dry_run: _zod.z.boolean().optional()
});
const UpgradeAllRulesRequest = exports.UpgradeAllRulesRequest = _zod.z.object({
  mode: _zod.z.literal('ALL_RULES'),
  pick_version: PickVersionValues.optional(),
  filter: _prebuilt_rules_filter.PrebuiltRulesFilter.optional(),
  on_conflict: UpgradeConflictResolution.optional(),
  dry_run: _zod.z.boolean().optional()
});
const SkipRuleUpgradeReason = exports.SkipRuleUpgradeReason = _zod.z.enum(['RULE_UP_TO_DATE', 'CONFLICT']);
const SkipRuleUpgradeReasonEnum = exports.SkipRuleUpgradeReasonEnum = SkipRuleUpgradeReason.enum;
const RuleUpToDateSkipReason = exports.RuleUpToDateSkipReason = _zod.z.object({
  reason: _zod.z.literal(SkipRuleUpgradeReasonEnum.RULE_UP_TO_DATE),
  rule_id: _zod.z.string()
});
const UpgradeConflictSkipReason = exports.UpgradeConflictSkipReason = _zod.z.object({
  reason: _zod.z.literal(SkipRuleUpgradeReasonEnum.CONFLICT),
  rule_id: _zod.z.string(),
  conflict: _zod.z.nativeEnum(_model.ThreeWayDiffConflict)
});
const SkippedRuleUpgrade = exports.SkippedRuleUpgrade = _zod.z.discriminatedUnion('reason', [RuleUpToDateSkipReason, UpgradeConflictSkipReason]);
const PerformRuleUpgradeResponseBody = exports.PerformRuleUpgradeResponseBody = _zod.z.object({
  summary: _zod.z.object({
    total: _zod.z.number(),
    succeeded: _zod.z.number(),
    skipped: _zod.z.number(),
    failed: _zod.z.number()
  }),
  results: _zod.z.object({
    updated: _zod.z.array(_rule_schemas.RuleResponse),
    skipped: _zod.z.array(SkippedRuleUpgrade)
  }),
  errors: _zod.z.array(_model.AggregatedPrebuiltRuleError)
});
const PerformRuleUpgradeRequestBody = exports.PerformRuleUpgradeRequestBody = _zod.z.discriminatedUnion('mode', [UpgradeAllRulesRequest, UpgradeSpecificRulesRequest]);