"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCasesNavigationTree = void 0;
var _constants = require("../constants");
var _links = require("../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCasesNavigationTree = () => ({
  id: _constants.SecurityPageName.case,
  link: (0, _links.securityLink)(_constants.SecurityPageName.case),
  renderAs: 'item',
  children: [{
    id: _constants.SecurityPageName.caseCreate,
    link: (0, _links.securityLink)(_constants.SecurityPageName.caseCreate)
  }, {
    id: _constants.SecurityPageName.caseConfigure,
    link: (0, _links.securityLink)(_constants.SecurityPageName.caseConfigure)
  }]
});
exports.createCasesNavigationTree = createCasesNavigationTree;