"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetRolesRoutes = defineGetRolesRoutes;
var _configSchema = require("@kbn/config-schema");
var _coreSecurityServer = require("@kbn/core-security-server");
var _constants = require("../../../../common/constants");
var _authorization = require("../../../authorization");
var _errors = require("../../../errors");
var _licensed_route_handler = require("../../licensed_route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineGetRolesRoutes({
  router,
  authz,
  getFeatures,
  subFeaturePrivilegeIterator,
  logger
}) {
  router.versioned.get({
    path: '/api/security/role/{name}',
    access: 'public',
    summary: `Get a role`,
    options: {
      tags: ['oas-tag:roles']
    },
    security: {
      authz: _coreSecurityServer.AuthzDisabled.delegateToESClient
    }
  }).addVersion({
    version: _constants.API_VERSIONS.roles.public.v1,
    validate: {
      request: {
        params: _configSchema.schema.object({
          name: _configSchema.schema.string({
            minLength: 1,
            meta: {
              description: 'The role name.'
            }
          })
        }),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          replaceDeprecatedPrivileges: _configSchema.schema.maybe(_configSchema.schema.boolean({
            meta: {
              description: 'If `true` and the response contains any privileges that are associated with deprecated features, they are omitted in favor of details about the appropriate replacement feature privileges.'
            }
          }))
        }))
      },
      response: {
        200: {
          description: 'Indicates a successful call.'
        }
      }
    }
  }, (0, _licensed_route_handler.createLicensedRouteHandler)(async (context, request, response) => {
    try {
      const esClient = (await context.core).elasticsearch.client;
      const [features, elasticsearchRoles] = await Promise.all([getFeatures(), await esClient.asCurrentUser.security.getRole({
        name: request.params.name
      })]);
      const elasticsearchRole = elasticsearchRoles[request.params.name];
      if (elasticsearchRole) {
        var _request$query$replac, _request$query;
        return response.ok({
          body: (0, _authorization.transformElasticsearchRoleToRole)({
            features,
            subFeaturePrivilegeIterator,
            // @ts-expect-error `SecurityIndicesPrivileges.names` expected to be `string[]`
            elasticsearchRole,
            name: request.params.name,
            application: authz.applicationName,
            logger,
            replaceDeprecatedKibanaPrivileges: (_request$query$replac = (_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.replaceDeprecatedPrivileges) !== null && _request$query$replac !== void 0 ? _request$query$replac : false
          })
        });
      }
      return response.notFound();
    } catch (error) {
      return response.customError((0, _errors.wrapIntoCustomErrorResponse)(error));
    }
  }));
}