"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformErrorSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securityPluginTypesCommon = require("@kbn/security-plugin-types-common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformErrorMessages = {
  [_securityPluginTypesCommon.RoleTransformErrorReason.RESERVED_PRIVILEGES_MIXED]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.reservedPrivilegesMixed', {
    defaultMessage: 'Role contains reserved privileges mixed with non-reserved privileges.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.RESERVED_PRIVILEGES_WRONG_APP]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.reservedPrivilegesWrongApp', {
    defaultMessage: 'Role has reserved privileges assigned to non-reserved applications.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.SPACE_PRIVILEGES_GLOBAL]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.spacePrivilegesGlobal', {
    defaultMessage: 'Role has space privileges assigned globally.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.GLOBAL_PRIVILEGES_SPACE]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.globalPrivilegesSpace', {
    defaultMessage: 'Role has global or reserved privileges assigned to specific spaces.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.BASE_FEATURE_PRIVILEGES_MIXED]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.baseFeaturePrivilegesMixed', {
    defaultMessage: 'Role has base privileges mixed with feature privileges.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.GLOBAL_RESOURCE_MIXED]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.globalResourceMixed', {
    defaultMessage: 'Role has global resource mixed with other resources.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.INVALID_RESOURCE_FORMAT]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.invalidResourceFormat', {
    defaultMessage: 'Role has improperly formatted resource entries.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.DUPLICATED_RESOURCES]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.duplicatedResources', {
    defaultMessage: 'Role has duplicated resources in entries.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.FEATURE_REQUIRES_ALL_SPACES]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.featureRequiresAllSpaces', {
    defaultMessage: 'Role has feature privileges that require all spaces but are assigned to specific spaces.'
  }),
  [_securityPluginTypesCommon.RoleTransformErrorReason.DISABLED_FEATURE_PRIVILEGES]: _i18n.i18n.translate('xpack.security.management.editRole.transformError.disabledFeaturePrivileges', {
    defaultMessage: 'Role uses disabled feature privileges.'
  }),
  default: _i18n.i18n.translate('xpack.security.management.editRole.transformErrorSectionDescription', {
    defaultMessage: 'This role definition is invalid, and cannot be edited through this screen.'
  })
};
const KIBANA_ERROR_PREFIX = 'kibana:';
class TransformErrorSection extends _react.PureComponent {
  getErrorMessage() {
    var _transformErrors$find, _transformErrorMessag;
    const {
      transformErrors
    } = this.props;
    const {
      reason,
      state
    } = (_transformErrors$find = transformErrors.find(error => error.reason.startsWith(KIBANA_ERROR_PREFIX))) !== null && _transformErrors$find !== void 0 ? _transformErrors$find : {};
    const normalizedReason = reason === null || reason === void 0 ? void 0 : reason.replace(KIBANA_ERROR_PREFIX, '');
    const errorMessage = (_transformErrorMessag = transformErrorMessages[normalizedReason]) !== null && _transformErrorMessag !== void 0 ? _transformErrorMessag : transformErrorMessages.default;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, errorMessage), state && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "s",
      paddingSize: "s",
      overflowHeight: 100,
      isCopyable: true,
      title: _i18n.i18n.translate('xpack.security.management.editRole.codeBlock.details', {
        defaultMessage: 'Configuration causing the error'
      })
    }, JSON.stringify(state))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.transformErrorSectionTitle",
        defaultMessage: "Malformed role"
      })),
      body: this.getErrorMessage()
    });
  }
}
exports.TransformErrorSection = TransformErrorSection;