"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _playground_provider = require("./providers/playground_provider");
var _use_kibana = require("./hooks/use_kibana");
var _types = require("./types");
var _app = require("./components/app");
var _use_playground_breadcrumbs = require("./hooks/use_playground_breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PlaygroundOverview = ({
  pageMode = _types.PlaygroundPageMode.chat
}) => {
  const {
    services: {
      history,
      console: consolePlugin,
      searchNavigation
    }
  } = (0, _use_kibana.useKibana)();
  (0, _use_playground_breadcrumbs.usePlaygroundBreadcrumbs)();
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null, [consolePlugin]);
  return /*#__PURE__*/_react.default.createElement(_playground_provider.PlaygroundProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "svlPlaygroundPage",
    grow: false,
    panelled: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history)
  }, /*#__PURE__*/_react.default.createElement(_app.App, {
    showDocs: true,
    pageMode: pageMode
  }), embeddableConsole));
};
exports.PlaygroundOverview = PlaygroundOverview;