"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLAYGROUND_URL = '/chat';
class PlaygroundLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const defaultIndex = params['default-index'];
      const path = `${PLAYGROUND_URL}${defaultIndex ? `?default-index=${defaultIndex}` : ''}`;
      return {
        app: _common.PLUGIN_ID,
        path,
        state: {}
      };
    });
    (0, _defineProperty2.default)(this, "id", 'PLAYGROUND_LOCATOR_ID');
  }
}
exports.PlaygroundLocatorDefinition = PlaygroundLocatorDefinition;