"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNavigationPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _classic_navigation = require("./classic_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchNavigationPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "currentChromeStyle", undefined);
    (0, _defineProperty2.default)(this, "baseClassicNavItemsFn", undefined);
    (0, _defineProperty2.default)(this, "coreStart", undefined);
    (0, _defineProperty2.default)(this, "pluginsStart", undefined);
    (0, _defineProperty2.default)(this, "onAppMountHandlers", []);
    (0, _defineProperty2.default)(this, "chromeSub", void 0);
    this.initializerContext = initializerContext;
    this.logger = this.initializerContext.logger.get();
  }
  setup(_core) {
    return {};
  }
  start(core, plugins) {
    this.coreStart = core;
    this.pluginsStart = plugins;
    this.chromeSub = core.chrome.getChromeStyle$().subscribe(value => {
      this.currentChromeStyle = value;
    });
    return {
      handleOnAppMount: this.handleOnAppMount.bind(this),
      registerOnAppMountHandler: this.registerOnAppMountHandler.bind(this),
      setGetBaseClassicNavItems: this.setGetBaseClassicNavItems.bind(this),
      useClassicNavigation: this.useClassicNavigation.bind(this),
      breadcrumbs: {
        setSearchBreadCrumbs: this.setBreadcrumbs.bind(this),
        clearBreadcrumbs: this.clearBreadcrumbs.bind(this)
      }
    };
  }
  stop() {
    if (this.chromeSub) {
      this.chromeSub.unsubscribe();
      this.chromeSub = undefined;
    }
  }
  async handleOnAppMount() {
    if (this.onAppMountHandlers.length === 0) return;
    try {
      await Promise.all(this.onAppMountHandlers);
    } catch (e) {
      this.logger.warn('Error handling app mount functions for search navigation');
      this.logger.warn(e);
    }
  }
  registerOnAppMountHandler(handler) {
    this.onAppMountHandlers.push(handler);
  }
  setGetBaseClassicNavItems(classicNavItemsFn) {
    this.baseClassicNavItemsFn = classicNavItemsFn;
  }
  useClassicNavigation(history) {
    if (this.baseClassicNavItemsFn === undefined || this.coreStart === undefined || this.currentChromeStyle !== 'classic') return undefined;
    return (0, _classic_navigation.classicNavigationFactory)(this.baseClassicNavItemsFn(), this.coreStart, history);
  }
  setBreadcrumbs(breadcrumbs, {
    forClassicChromeStyle = false
  } = {}) {
    var _this$pluginsStart;
    if (forClassicChromeStyle === true && this.currentChromeStyle !== 'classic') return;
    const searchBreadcrumbs = [this.getSearchHomeBreadcrumb(), ...breadcrumbs];
    if ((_this$pluginsStart = this.pluginsStart) !== null && _this$pluginsStart !== void 0 && _this$pluginsStart.serverless) {
      this.pluginsStart.serverless.setBreadcrumbs(searchBreadcrumbs);
    } else {
      var _this$coreStart;
      (_this$coreStart = this.coreStart) === null || _this$coreStart === void 0 ? void 0 : _this$coreStart.chrome.setBreadcrumbs(searchBreadcrumbs);
    }
  }
  clearBreadcrumbs() {
    var _this$pluginsStart2;
    if ((_this$pluginsStart2 = this.pluginsStart) !== null && _this$pluginsStart2 !== void 0 && _this$pluginsStart2.serverless) {
      this.pluginsStart.serverless.setBreadcrumbs([]);
    } else {
      var _this$coreStart2;
      (_this$coreStart2 = this.coreStart) === null || _this$coreStart2 === void 0 ? void 0 : _this$coreStart2.chrome.setBreadcrumbs([]);
    }
  }
  getSearchHomeBreadcrumb() {
    // TODO: When search_navigation handles solution nav, use the default
    // home deep link for this breadcrumb's path.
    return {
      text: _i18n.i18n.translate('xpack.searchNavigation.breadcrumbs.home.title', {
        defaultMessage: 'Elasticsearch'
      })
    };
  }
}
exports.SearchNavigationPlugin = SearchNavigationPlugin;