"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableData = void 0;
var _react = require("react");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _constants = require("../components/all_inference_endpoints/constants");
var _types = require("../components/all_inference_endpoints/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTableData = (inferenceEndpoints, queryParams, filterOptions, searchKey) => {
  const tableData = (0, _react.useMemo)(() => {
    let filteredEndpoints = inferenceEndpoints;
    if (filterOptions.provider.length > 0) {
      filteredEndpoints = filteredEndpoints.filter(endpoint => filterOptions.provider.includes(_inferenceEndpointUiCommon.ServiceProviderKeys[endpoint.service]));
    }
    if (filterOptions.type.length > 0) {
      filteredEndpoints = filteredEndpoints.filter(endpoint => filterOptions.type.includes(endpoint.task_type));
    }
    return filteredEndpoints.filter(endpoint => endpoint.inference_id.includes(searchKey));
  }, [inferenceEndpoints, searchKey, filterOptions]);
  const sortedTableData = (0, _react.useMemo)(() => {
    return [...tableData].sort((a, b) => {
      const aValue = a[queryParams.sortField];
      const bValue = b[queryParams.sortField];
      if (queryParams.sortOrder === _types.SortOrder.asc) {
        return aValue.localeCompare(bValue);
      } else {
        return bValue.localeCompare(aValue);
      }
    });
  }, [tableData, queryParams]);
  const pagination = (0, _react.useMemo)(() => {
    var _inferenceEndpoints$l;
    return {
      pageIndex: queryParams.page - 1,
      pageSize: queryParams.perPage,
      pageSizeOptions: _types.INFERENCE_ENDPOINTS_TABLE_PER_PAGE_VALUES,
      totalItemCount: (_inferenceEndpoints$l = inferenceEndpoints.length) !== null && _inferenceEndpoints$l !== void 0 ? _inferenceEndpoints$l : 0
    };
  }, [inferenceEndpoints, queryParams]);
  const paginatedSortedTableData = (0, _react.useMemo)(() => {
    const pageSize = pagination.pageSize || _constants.DEFAULT_TABLE_LIMIT;
    const startIndex = pagination.pageIndex * pageSize;
    const endIndex = startIndex + pageSize;
    return sortedTableData.slice(startIndex, endIndex);
  }, [sortedTableData, pagination]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      direction: queryParams.sortOrder,
      field: queryParams.sortField
    }
  }), [queryParams.sortField, queryParams.sortOrder]);
  return {
    tableData,
    sortedTableData,
    paginatedSortedTableData,
    pagination,
    sorting
  };
};
exports.useTableData = useTableData;