"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryKeys = exports.MutationKeys = exports.INDEX_PLACEHOLDER = exports.ELASTICSEARCH_URL_PLACEHOLDER = exports.DEFAULT_DOCUMENT_PAGE_SIZE = exports.API_KEY_PLACEHOLDER = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let QueryKeys = exports.QueryKeys = /*#__PURE__*/function (QueryKeys) {
  QueryKeys["FetchIndex"] = "fetchIndex";
  QueryKeys["FetchMapping"] = "fetchMapping";
  QueryKeys["FetchSearchIndicesStatus"] = "fetchSearchIndicesStatus";
  QueryKeys["FetchUserStartPrivileges"] = "fetchUserStartPrivileges";
  QueryKeys["SearchDocuments"] = "searchDocuments";
  return QueryKeys;
}({});
let MutationKeys = exports.MutationKeys = /*#__PURE__*/function (MutationKeys) {
  MutationKeys["SearchIndicesCreateIndex"] = "searchIndicesCreateIndex";
  MutationKeys["SearchIndicesDeleteDocument"] = "searchIndicesDeleteDocument";
  return MutationKeys;
}({});
const ELASTICSEARCH_URL_PLACEHOLDER = exports.ELASTICSEARCH_URL_PLACEHOLDER = 'https://your_deployment_url';
const API_KEY_PLACEHOLDER = exports.API_KEY_PLACEHOLDER = 'YOUR_API_KEY';
const INDEX_PLACEHOLDER = exports.INDEX_PLACEHOLDER = 'my-index';
const DEFAULT_DOCUMENT_PAGE_SIZE = exports.DEFAULT_DOCUMENT_PAGE_SIZE = 50;