"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStartPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_kibana = require("../../hooks/use_kibana");
var _use_indices_status = require("../../hooks/api/use_indices_status");
var _use_user_permissions = require("../../hooks/api/use_user_permissions");
var _use_indices_redirect = require("./hooks/use_indices_redirect");
var _elasticsearch_start = require("./elasticsearch_start");
var _load_indices_status_error = require("../shared/load_indices_status_error");
var _breadcrumbs = require("../shared/breadcrumbs");
var _use_page_chrome = require("../../hooks/use_page_chrome");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageTitle = _i18n.i18n.translate('xpack.searchIndices.startPage.docTitle', {
  defaultMessage: 'Create your first index'
});
const ElasticsearchStartPage = () => {
  const {
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: indicesData,
    isInitialLoading,
    isError: hasIndicesStatusFetchError,
    error: indicesFetchError
  } = (0, _use_indices_status.useIndicesStatusQuery)();
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)();
  (0, _use_page_chrome.usePageChrome)(PageTitle, [..._breadcrumbs.IndexManagementBreadcrumbs, {
    text: PageTitle
  }]);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null, [consolePlugin]);
  (0, _use_indices_redirect.useIndicesRedirect)(indicesData);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "elasticsearchStartPage",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "center",
    restrictWidth: false,
    grow: true
  }, isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, null), hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_load_indices_status_error.LoadIndicesStatusError, {
    error: indicesFetchError
  }), !isInitialLoading && !hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_elasticsearch_start.ElasticsearchStart, {
    indicesData: indicesData,
    userPrivileges: userPrivileges
  })), embeddableConsole);
};
exports.ElasticsearchStartPage = ElasticsearchStartPage;