"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesRedirect = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _utils = require("../../utils");
var _usage_tracker_context = require("../../../contexts/usage_tracker_context");
var _constants = require("../../../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesRedirect = indicesStatus => {
  const {
    application,
    http
  } = (0, _use_kibana.useKibana)().services;
  const [lastStatus, setLastStatus] = (0, _react.useState)(() => undefined);
  const [hasDoneRedirect, setHasDoneRedirect] = (0, _react.useState)(() => false);
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  return (0, _react.useEffect)(() => {
    if (hasDoneRedirect) {
      return;
    }
    if (!indicesStatus) {
      return;
    }
    if (indicesStatus.indexNames.length === 0) {
      setLastStatus(indicesStatus);
      return;
    }
    if (lastStatus === undefined && indicesStatus.indexNames.length > 0) {
      application.navigateToApp('management', {
        deepLinkId: 'index_management'
      });
      setHasDoneRedirect(true);
      return;
    }
    if (indicesStatus.indexNames.length === 1) {
      (0, _utils.navigateToIndexDetails)(application, http, indicesStatus.indexNames[0]);
      setHasDoneRedirect(true);
      usageTracker.click(_constants.AnalyticsEvents.startCreateIndexCreatedRedirect);
      return;
    }
    application.navigateToApp('management', {
      deepLinkId: 'index_management'
    });
    setHasDoneRedirect(true);
  }, [application, http, indicesStatus, lastStatus, setHasDoneRedirect, usageTracker, hasDoneRedirect]);
};
exports.useIndicesRedirect = useIndicesRedirect;