"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexCodeView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tryInConsole = require("@kbn/try-in-console");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _code_examples = require("../../code_examples");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_kibana = require("../../hooks/use_kibana");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _api_key_callout = require("./api_key_callout");
var _code_sample = require("./code_sample");
var _use_create_index_coding_examples = require("./hooks/use_create_index_coding_examples");
var _language_selector = require("./language_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIndexCodeView = ({
  analyticsEvents,
  canCreateApiKey,
  changeCodingLanguage,
  indexName,
  selectedLanguage
}) => {
  const {
    application,
    share,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const selectedCodeExamples = (0, _use_create_index_coding_examples.useCreateIndexCodingExamples)();
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const {
    apiKey,
    apiKeyIsVisible
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const codeParams = (0, _react.useMemo)(() => {
    return {
      indexName: indexName || undefined,
      elasticsearchURL: elasticsearchUrl,
      apiKey: apiKeyIsVisible && apiKey ? apiKey : undefined
    };
  }, [indexName, elasticsearchUrl, apiKeyIsVisible, apiKey]);
  const selectedCodeExample = (0, _react.useMemo)(() => {
    return selectedCodeExamples[selectedLanguage];
  }, [selectedLanguage, selectedCodeExamples]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "createIndexCodeView"
  }, canCreateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_api_key_callout.APIKeyCallout, {
    apiKey: apiKey
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      maxWidth: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_language_selector.LanguageSelector, {
    options: _code_examples.LanguageOptions,
    selectedLanguage: selectedLanguage,
    onSelectLanguage: changeCodingLanguage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: selectedCodeExamples.sense.createIndex(codeParams),
    application: application,
    sharePlugin: share,
    consolePlugin: consolePlugin,
    telemetryId: `${selectedLanguage}_create_index`,
    onClick: () => {
      usageTracker.click([analyticsEvents.runInConsole, `${analyticsEvents.runInConsole}_${selectedLanguage}`]);
    }
  }))), selectedCodeExample.installCommand && /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    title: selectedCodeExamples.installTitle,
    description: selectedCodeExamples.installDescription,
    language: "shell",
    code: selectedCodeExample.installCommand,
    onCodeCopyClick: () => {
      usageTracker.click([analyticsEvents.installCommands, `${analyticsEvents.installCommands}_${selectedLanguage}`]);
    }
  }), /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "createIndex",
    title: selectedCodeExamples.createIndexTitle,
    description: selectedCodeExamples.createIndexDescription,
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExample.createIndex(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([analyticsEvents.createIndex, `${analyticsEvents.createIndex}_${selectedLanguage}`, `${analyticsEvents.createIndex}_${selectedLanguage}_${selectedCodeExamples.exampleType}`]);
    }
  }));
};
exports.CreateIndexCodeView = CreateIndexCodeView;