"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesRedirect = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _indices = require("../../../utils/indices");
var _utils = require("../../utils");
var _usage_tracker_context = require("../../../contexts/usage_tracker_context");
var _constants = require("../../../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesRedirect = indicesStatus => {
  const {
    application,
    http
  } = (0, _use_kibana.useKibana)().services;
  const [initialStatus, setInitialStatus] = (0, _react.useState)(undefined);
  const [hasDoneRedirect, setHasDoneRedirect] = (0, _react.useState)(() => false);
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  return (0, _react.useEffect)(() => {
    if (hasDoneRedirect) {
      return;
    }
    if (!indicesStatus) {
      return;
    }
    if (initialStatus === undefined) {
      setInitialStatus(indicesStatus);
      return;
    }
    const newIndexName = (0, _indices.getFirstNewIndexName)(initialStatus.indexNames, indicesStatus.indexNames);
    if (newIndexName) {
      (0, _utils.navigateToIndexDetails)(application, http, newIndexName);
      setHasDoneRedirect(true);
      usageTracker.click(_constants.AnalyticsEvents.createIndexIndexCreatedRedirect);
      return;
    }
  }, [application, http, indicesStatus, initialStatus, setHasDoneRedirect, usageTracker, hasDoneRedirect]);
};
exports.useIndicesRedirect = useIndicesRedirect;