"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DenseVectorServerlessCodeExamples = void 0;
var _i18n = require("@kbn/i18n");
var _javascript = require("./javascript");
var _python = require("./python");
var _sense = require("./sense");
var _curl = require("./curl");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DenseVectorServerlessCodeExamples = exports.DenseVectorServerlessCodeExamples = {
  installTitle: _constants.INSTALL_INSTRUCTIONS_TITLE,
  installDescription: _constants.INSTALL_INSTRUCTIONS_DESCRIPTION,
  addMappingsTitle: _i18n.i18n.translate('xpack.searchIndices.codeExamples.serverless.denseVector.mappingsTitle', {
    defaultMessage: 'Define field mappings'
  }),
  addMappingsDescription: _i18n.i18n.translate('xpack.searchIndices.codeExamples.serverless.denseVector.mappingsDescription', {
    defaultMessage: 'This example defines two fields: a 3-dimensional dense vector field and a text field. You can add more field types by modifying the mappings in your API call, or in the mappings tab.'
  }),
  defaultMapping: {
    vector: {
      type: 'dense_vector',
      dims: 3
    },
    text: {
      type: 'text'
    }
  },
  sense: _sense.ConsoleVectorsIngestDataExample,
  curl: _curl.CurlVectorsIngestDataExample,
  python: _python.PythonServerlessVectorsIngestDataExample,
  javascript: _javascript.JSServerlessIngestVectorDataExample
};