"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RichResultHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Term = ({
  label
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, label, ":")));
const Definition = ({
  label
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, label));
const MetadataPopover = ({
  id,
  onDocumentDelete,
  score,
  showScore = false
}) => {
  const [popoverIsOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const closePopover = () => setPopoverIsOpen(false);
  const metaDataIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "empty",
    size: "s",
    iconType: "info",
    color: "primary",
    "data-test-subj": "documentMetadataButton",
    onClick: e => {
      e.stopPropagation();
      setPopoverIsOpen(!popoverIsOpen);
    },
    "aria-label": _i18n.i18n.translate('searchIndexDocuments.result.header.metadata.icon.ariaLabel', {
      defaultMessage: 'Metadata for document: {id}',
      values: {
        id
      }
    })
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: metaDataIcon,
    isOpen: popoverIsOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('searchIndexDocuments.result.header.metadata.title', {
    defaultMessage: 'Document metadata'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    css: (0, _react2.css)`
          width: 20rem;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(Term, {
    label: "ID"
  }), /*#__PURE__*/_react.default.createElement(Definition, {
    label: id
  }))), score && showScore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(Term, {
    label: _i18n.i18n.translate('searchIndexDocuments.result.header.metadata.score', {
      defaultMessage: 'Score'
    })
  }), /*#__PURE__*/_react.default.createElement(Definition, {
    label: score === null || score === void 0 ? void 0 : score.toString()
  })))), onDocumentDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    color: "danger",
    size: "s",
    "data-test-subj": "deleteDocumentButton",
    onClick: e => {
      e.stopPropagation();
      onDocumentDelete();
      closePopover();
    },
    fullWidth: true
  }, _i18n.i18n.translate('searchIndexDocuments.result.header.metadata.deleteDocument', {
    defaultMessage: 'Delete document'
  }))));
};
const Score = ({
  score
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    hasShadow: false,
    color: "subdued",
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visGauge",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    css: (0, _react2.css)`
              inline-size: 5ch;
              max-inline-size: 100%;
            `,
    paddingSize: "none",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs"
  }, score ? score.toString().substring(0, 5) : '-')))));
};
const RichResultHeader = ({
  title,
  metaData,
  rightSideActions = null,
  showScore = false,
  onTitleClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
        min-height: ${euiTheme.base * 1}px;
        max-height: ${euiTheme.base * 8}px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, showScore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Score, {
    score: metaData.score
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, onTitleClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onTitleClick,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title))), !!metaData && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MetadataPopover, (0, _extends2.default)({}, metaData, {
    showScore: showScore
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, rightSideActions)));
};
exports.RichResultHeader = RichResultHeader;