"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncJobTypeToText = exports.isSyncCancellable = void 0;
exports.syncStatusToColor = syncStatusToColor;
exports.syncStatusToText = syncStatusToText;
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function syncStatusToText(status) {
  switch (status) {
    case _.SyncStatus.COMPLETED:
      return _i18n.i18n.translate('searchConnectors.syncStatus.completed', {
        defaultMessage: 'Sync complete'
      });
    case _.SyncStatus.ERROR:
      return _i18n.i18n.translate('searchConnectors.syncStatus.error', {
        defaultMessage: 'Sync failure'
      });
    case _.SyncStatus.IN_PROGRESS:
      return _i18n.i18n.translate('searchConnectors.syncStatus.inProgress', {
        defaultMessage: 'Sync in progress'
      });
    case _.SyncStatus.CANCELED:
      return _i18n.i18n.translate('searchConnectors.syncStatus.canceling', {
        defaultMessage: 'Sync canceled'
      });
    case _.SyncStatus.CANCELING:
      return _i18n.i18n.translate('searchConnectors.syncStatus.canceled', {
        defaultMessage: 'Canceling sync'
      });
    case _.SyncStatus.PENDING:
      return _i18n.i18n.translate('searchConnectors.syncStatus.pending', {
        defaultMessage: 'Sync pending'
      });
    case _.SyncStatus.SUSPENDED:
      return _i18n.i18n.translate('searchConnectors.syncStatus.suspended', {
        defaultMessage: 'Sync suspended'
      });
    default:
      return status;
  }
}
function syncStatusToColor(status) {
  switch (status) {
    case _.SyncStatus.COMPLETED:
      return 'success';
    case _.SyncStatus.ERROR:
    case _.SyncStatus.CANCELED:
      return 'danger';
    case _.SyncStatus.IN_PROGRESS:
    case _.SyncStatus.PENDING:
    case _.SyncStatus.SUSPENDED:
    case _.SyncStatus.CANCELING:
      return 'warning';
    default:
      return 'default';
  }
}
const isSyncCancellable = syncStatus => {
  return syncStatus === _.SyncStatus.IN_PROGRESS || syncStatus === _.SyncStatus.PENDING || syncStatus === _.SyncStatus.SUSPENDED;
};
exports.isSyncCancellable = isSyncCancellable;
const syncJobTypeToText = syncType => {
  switch (syncType) {
    case _.SyncJobType.FULL:
      return _i18n.i18n.translate('searchConnectors.syncJobType.full', {
        defaultMessage: 'Full content'
      });
    case _.SyncJobType.INCREMENTAL:
      return _i18n.i18n.translate('searchConnectors.syncJobType.incremental', {
        defaultMessage: 'Incremental content'
      });
    default:
      return '';
  }
};
exports.syncJobTypeToText = syncJobTypeToText;