"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFiltering = void 0;
var _fetch_connectors = require("./fetch_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateFiltering = async (client, connectorId) => {
  const activateDraftFilteringResult = await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_filtering/activate`
  });
  if (activateDraftFilteringResult.result === 'updated') {
    var _connector$filtering, _connector$filtering$;
    const connector = await (0, _fetch_connectors.fetchConnectorById)(client, connectorId);
    return connector === null || connector === void 0 ? void 0 : (_connector$filtering = connector.filtering) === null || _connector$filtering === void 0 ? void 0 : (_connector$filtering$ = _connector$filtering[0]) === null || _connector$filtering$ === void 0 ? void 0 : _connector$filtering$.active;
  }
  return undefined;
};
exports.updateFiltering = updateFiltering;