"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExportModal = ({
  onCancel,
  onExport,
  onSelectedOptionsChange,
  options,
  filteredItemCount,
  selectedOptions,
  includeReferences,
  onIncludeReferenceChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModalTitle",
    defaultMessage: "Export {filteredItemCount, plural, one{# object} other {# objects}}",
    values: {
      filteredItemCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModalDescription",
      defaultMessage: "Select which types to export"
    }),
    labelType: "legend"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    options: options,
    idToSelectedMap: selectedOptions,
    onChange: optionId => {
      onSelectedOptionsChange({
        ...selectedOptions,
        ...{
          [optionId]: !selectedOptions[optionId]
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "includeReferencesDeep",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.includeReferencesDeepLabel",
      defaultMessage: "Include related objects"
    }),
    checked: includeReferences,
    onChange: () => onIncludeReferenceChange(!includeReferences)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onExport
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.exportAllButtonLabel",
    defaultMessage: "Export all"
  }))))))));
};
exports.ExportModal = ExportModal;