"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../shared_imports");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const schema = exports.schema = {
  name: {
    label: _i18n.i18n.translate('xpack.runtimeFields.form.nameLabel', {
      defaultMessage: 'Name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.runtimeFields.form.validations.nameIsRequiredErrorMessage', {
        defaultMessage: 'Give a name to the field.'
      }))
    }]
  },
  type: {
    label: _i18n.i18n.translate('xpack.runtimeFields.form.runtimeTypeLabel', {
      defaultMessage: 'Type'
    }),
    defaultValue: 'keyword',
    deserializer: fieldType => {
      var _RUNTIME_FIELD_OPTION;
      if (!fieldType) {
        return [];
      }
      const label = (_RUNTIME_FIELD_OPTION = _constants.RUNTIME_FIELD_OPTIONS.find(({
        value
      }) => value === fieldType)) === null || _RUNTIME_FIELD_OPTION === void 0 ? void 0 : _RUNTIME_FIELD_OPTION.label;
      return [{
        label: label !== null && label !== void 0 ? label : fieldType,
        value: fieldType
      }];
    },
    serializer: value => value[0].value
  },
  script: {
    source: {
      label: _i18n.i18n.translate('xpack.runtimeFields.form.defineFieldLabel', {
        defaultMessage: 'Define script (optional)'
      })
    }
  }
};