"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleRegistrySearchStrategyProvider = exports.RULE_SEARCH_STRATEGY_NAME = exports.EMPTY_RESPONSE = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _server = require("@kbn/alerting-plugin/server");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _report_search_error = require("@kbn/data-plugin/server/search/report_search_error");
var _lib = require("@kbn/alerting-plugin/server/lib");
var _constants = require("../../common/constants");
var _lib2 = require("../lib");
var _get_rule_type_ids_filter = require("../lib/get_rule_type_ids_filter");
var _get_consumers_filter = require("../lib/get_consumers_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_RESPONSE = exports.EMPTY_RESPONSE = {
  rawResponse: {
    hits: {
      total: 0,
      hits: []
    }
  }
};
const RULE_SEARCH_STRATEGY_NAME = exports.RULE_SEARCH_STRATEGY_NAME = 'privateRuleRegistryAlertsSearchStrategy';

// these are deprecated types should never show up in any alert table
const EXCLUDED_RULE_TYPE_IDS = ['siem.notifications'];
const ruleRegistrySearchStrategyProvider = (data, alerting, logger, security, spaces) => {
  const internalUserEs = data.search.searchAsInternalUser;
  const requestUserEs = data.search.getSearchStrategy(_common.ENHANCED_ES_SEARCH_STRATEGY);
  return {
    search: (request, options, deps) => {
      let params = {};

      // SIEM uses RBAC fields in their alerts but also utilizes ES DLS which
      // is different than every other solution so we need to special case
      // those requests.
      const isAnyRuleTypeESAuthorized = request.ruleTypeIds.some(_ruleDataUtils.isSiemRuleType);
      const isEachRuleTypeESAuthorized =
      // every returns true for empty arrays
      request.ruleTypeIds.length > 0 && request.ruleTypeIds.every(_ruleDataUtils.isSiemRuleType);
      const registeredRuleTypes = alerting.listTypes();
      const ruleTypesWithoutInternalRuleTypes = getRuleTypesWithoutInternalRuleTypes(registeredRuleTypes);
      const [validRuleTypeIds, _] = (0, _lodash.partition)(request.ruleTypeIds, ruleTypeId => ruleTypesWithoutInternalRuleTypes.has(ruleTypeId));
      if (isAnyRuleTypeESAuthorized && !isEachRuleTypeESAuthorized) {
        throw new _report_search_error.KbnSearchError(`The ${RULE_SEARCH_STRATEGY_NAME} search strategy is unable to accommodate requests containing multiple rule types with mixed authorization.`, 400);
      }
      const securityAuditLogger = security === null || security === void 0 ? void 0 : security.audit.asScoped(deps.request);
      const getActiveSpace = async () => spaces === null || spaces === void 0 ? void 0 : spaces.spacesService.getActiveSpace(deps.request);
      const getAsync = async ruleTypeIds => {
        const [space, authorization] = await Promise.all([getActiveSpace(), alerting.getAlertingAuthorizationWithRequest(deps.request)]);
        let authzFilter;
        if (!isAnyRuleTypeESAuthorized && ruleTypeIds.length > 0) {
          authzFilter = await (0, _lib2.getAuthzFilter)(authorization, _server.ReadOperations.Find);
        }
        const authorizedRuleTypes = await authorization.getAllAuthorizedRuleTypesFindOperation({
          authorizationEntity: _server.AlertingAuthorizationEntity.Alert,
          ruleTypeIds
        });
        return {
          space,
          authzFilter,
          authorizedRuleTypes
        };
      };
      return (0, _rxjs.from)(getAsync(validRuleTypeIds)).pipe((0, _rxjs.mergeMap)(({
        space,
        authzFilter,
        authorizedRuleTypes
      }) => {
        var _request$query, _request$query$bool, _request$query2, _request$query2$bool, _request$query3, _request$query3$bool, _request$query4, _request$query4$bool, _request$sort, _request$query5, _request$query6, _request$query7, _request$fields;
        const authorizedRuleTypesIds = Array.from(authorizedRuleTypes.keys());
        const ruleTypes = (authorizedRuleTypesIds !== null && authorizedRuleTypesIds !== void 0 ? authorizedRuleTypesIds : []).filter(ruleTypeId => !EXCLUDED_RULE_TYPE_IDS.includes(ruleTypeId));
        const indices = alerting.getAlertIndicesAlias(ruleTypes, space === null || space === void 0 ? void 0 : space.id);
        if (indices.length === 0) {
          return (0, _rxjs.of)(EMPTY_RESPONSE);
        }
        const filter = (_request$query = request.query) !== null && _request$query !== void 0 && (_request$query$bool = _request$query.bool) !== null && _request$query$bool !== void 0 && _request$query$bool.filter ? Array.isArray((_request$query2 = request.query) === null || _request$query2 === void 0 ? void 0 : (_request$query2$bool = _request$query2.bool) === null || _request$query2$bool === void 0 ? void 0 : _request$query2$bool.filter) ? (_request$query3 = request.query) === null || _request$query3 === void 0 ? void 0 : (_request$query3$bool = _request$query3.bool) === null || _request$query3$bool === void 0 ? void 0 : _request$query3$bool.filter : [(_request$query4 = request.query) === null || _request$query4 === void 0 ? void 0 : (_request$query4$bool = _request$query4.bool) === null || _request$query4$bool === void 0 ? void 0 : _request$query4$bool.filter] : [];
        if (authzFilter) {
          filter.push(authzFilter);
        }
        if (space !== null && space !== void 0 && space.id) {
          filter.push((0, _lib2.getSpacesFilter)(space.id));
        }
        const ruleTypeFilter = (0, _get_rule_type_ids_filter.getRuleTypeIdsFilter)(request.ruleTypeIds);
        const consumersFilter = (0, _get_consumers_filter.getConsumersFilter)(request.consumers);
        if (consumersFilter) {
          filter.push(consumersFilter);
        }
        if (ruleTypeFilter) {
          filter.push(ruleTypeFilter);
        }
        const sort = (_request$sort = request.sort) !== null && _request$sort !== void 0 ? _request$sort : [];
        const query = {
          ...(((_request$query5 = request.query) === null || _request$query5 === void 0 ? void 0 : _request$query5.ids) != null ? {
            ids: (_request$query6 = request.query) === null || _request$query6 === void 0 ? void 0 : _request$query6.ids
          } : {
            bool: {
              ...((_request$query7 = request.query) === null || _request$query7 === void 0 ? void 0 : _request$query7.bool),
              filter
            }
          })
        };
        let fields = (_request$fields = request === null || request === void 0 ? void 0 : request.fields) !== null && _request$fields !== void 0 ? _request$fields : [];
        fields.push({
          field: 'kibana.alert.*',
          include_unmapped: false
        });
        if (isAnyRuleTypeESAuthorized) {
          fields.push({
            field: 'signal.*',
            include_unmapped: false
          });
          fields = fields.concat((0, _alertsAsDataUtils.buildAlertFieldsRequest)([], false));
        } else {
          // only for o11y solutions
          fields.push({
            field: '*',
            include_unmapped: true
          });
        }
        const size = request.pagination ? request.pagination.pageSize : _constants.MAX_ALERT_SEARCH_SIZE;
        params = {
          allow_no_indices: true,
          index: indices,
          ignore_unavailable: true,
          body: {
            _source: false,
            fields,
            sort,
            size,
            from: request.pagination ? request.pagination.pageIndex * size : 0,
            query,
            ...(request.runtimeMappings ? {
              runtime_mappings: request.runtimeMappings
            } : {}),
            ...(request.minScore ? {
              min_score: request.minScore
            } : {}),
            ...(request.trackScores ? {
              track_scores: request.trackScores
            } : {})
          }
        };
        return (isAnyRuleTypeESAuthorized ? requestUserEs : internalUserEs).search({
          id: request.id,
          params
        }, options, deps);
      }), (0, _rxjs.map)(response => {
        // Do we have to loop over each hit? Yes.
        // ecs auditLogger requires that we log each alert independently
        if (securityAuditLogger != null) {
          var _response$rawResponse, _response$rawResponse2;
          (_response$rawResponse = response.rawResponse.hits) === null || _response$rawResponse === void 0 ? void 0 : (_response$rawResponse2 = _response$rawResponse.hits) === null || _response$rawResponse2 === void 0 ? void 0 : _response$rawResponse2.forEach(hit => {
            securityAuditLogger.log((0, _lib.alertAuditEvent)({
              action: _lib.AlertAuditAction.FIND,
              id: hit._id,
              outcome: 'success'
            }));
          });
        }
        try {
          response.inspect = {
            dsl: [JSON.stringify(params)]
          };
        } catch (error) {
          logger.error(`Failed to stringify rule registry search strategy params: ${error}`);
          response.inspect = {
            dsl: []
          };
        }
        return response;
      }), (0, _rxjs.catchError)(err => {
        var _err$output;
        if (securityAuditLogger != null && (err === null || err === void 0 ? void 0 : (_err$output = err.output) === null || _err$output === void 0 ? void 0 : _err$output.statusCode) === 403) {
          securityAuditLogger.log((0, _lib.alertAuditEvent)({
            action: _lib.AlertAuditAction.FIND,
            outcome: 'failure',
            error: err
          }));
        }
        if (_boom.default.isBoom(err)) {
          throw new _report_search_error.KbnSearchError(err.output.payload.message, err.output.statusCode);
        }
        if (err instanceof _report_search_error.KbnSearchError) {
          throw err;
        }
        throw new _report_search_error.KbnSearchError(err.message, 500);
      }));
    },
    cancel: async (id, options, deps) => {
      if (internalUserEs.cancel) internalUserEs.cancel(id, options, deps).catch(() => {});
      if (requestUserEs.cancel) requestUserEs.cancel(id, options, deps).catch(() => {});
    }
  };
};
exports.ruleRegistrySearchStrategyProvider = ruleRegistrySearchStrategyProvider;
const getRuleTypesWithoutInternalRuleTypes = registeredRuleTypes => new Map(Array.from(registeredRuleTypes).filter(([_id, ruleType]) => ruleType.internallyManaged == null || !Boolean(ruleType.internallyManaged)));