"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortTable = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringSort = fieldName => item => item[fieldName];
const sorters = {};
const sortTable = (array = [], sortField, isSortAscending) => {
  const sorter = sorters[sortField] || stringSort(sortField);
  const sorted = (0, _lodash.sortBy)(array, sorter);
  return isSortAscending ? sorted : sorted.reverse();
};
exports.sortTable = sortTable;