"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNVERSIONED_VERSION = exports.REPORTING_TRANSACTION_TYPE = exports.REPORTING_LEGACY_INDICES = exports.REPORTING_INDEX_TEMPLATE_MAPPING_META_FIELD = exports.REPORTING_DATA_STREAM_WILDCARD_WITH_LEGACY = exports.REPORTING_DATA_STREAM_WILDCARD = exports.REPORTING_DATA_STREAM_INDEX_TEMPLATE = exports.REPORTING_DATA_STREAM_COMPONENT_TEMPLATE = exports.REPORTING_DATA_STREAM_ALIAS = exports.PLUGIN_ID = exports.FieldType = exports.EventType = exports.API_USAGE_ERROR_TYPE = exports.API_USAGE_COUNTER_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'reporting';

/*
 * Storage
 */

// Used to index new documents
const REPORTING_DATA_STREAM_ALIAS = exports.REPORTING_DATA_STREAM_ALIAS = '.kibana-reporting';
// Used to retrieve settings
const REPORTING_DATA_STREAM_WILDCARD = exports.REPORTING_DATA_STREAM_WILDCARD = '.kibana-reporting*';
// Index pattern of plain indices before Reporting used Data Stream storage
const REPORTING_LEGACY_INDICES = exports.REPORTING_LEGACY_INDICES = '.reporting-*';
// Used to search for all reports and check for managing privileges
const REPORTING_DATA_STREAM_WILDCARD_WITH_LEGACY = exports.REPORTING_DATA_STREAM_WILDCARD_WITH_LEGACY = '.reporting-*,.kibana-reporting*';
// Name of component template which Kibana overrides for lifecycle settings
const REPORTING_DATA_STREAM_COMPONENT_TEMPLATE = exports.REPORTING_DATA_STREAM_COMPONENT_TEMPLATE = 'kibana-reporting@custom';
// Name of index template
const REPORTING_DATA_STREAM_INDEX_TEMPLATE = exports.REPORTING_DATA_STREAM_INDEX_TEMPLATE = '.kibana-reporting';
// Name of mapping meta field which contains the version of the index template
// see: https://github.com/elastic/elasticsearch/pull/133846
const REPORTING_INDEX_TEMPLATE_MAPPING_META_FIELD = exports.REPORTING_INDEX_TEMPLATE_MAPPING_META_FIELD = 'template_version';

/*
 * Telemetry
 */

// API Counters
const API_USAGE_COUNTER_TYPE = exports.API_USAGE_COUNTER_TYPE = 'reportingApi';
const API_USAGE_ERROR_TYPE = exports.API_USAGE_ERROR_TYPE = 'reportingApiError';

// Event-Based Counters
let EventType = exports.EventType = /*#__PURE__*/function (EventType) {
  EventType["REPORT_CREATION"] = "report_creation";
  EventType["REPORT_CLAIM"] = "report_claim";
  EventType["REPORT_COMPLETION_CSV"] = "report_completion_csv";
  EventType["REPORT_COMPLETION_SCREENSHOT"] = "report_completion_screenshot";
  EventType["REPORT_ERROR"] = "report_error";
  EventType["REPORT_DOWNLOAD"] = "report_download";
  EventType["REPORT_DELETION"] = "report_deletion";
  return EventType;
}({});
let FieldType = exports.FieldType = /*#__PURE__*/function (FieldType) {
  FieldType["REPORT_ID"] = "report_id";
  FieldType["EXPORT_TYPE"] = "export_type";
  FieldType["OBJECT_TYPE"] = "object_type";
  FieldType["IS_DEPRECATED"] = "is_deprecated";
  FieldType["IS_PUBLIC_API"] = "is_public_api";
  FieldType["DURATION_MS"] = "duration_ms";
  FieldType["ERROR_CODE"] = "error_code";
  FieldType["ERROR_MESSAGE"] = "error_message";
  FieldType["BYTE_SIZE"] = "byte_size";
  FieldType["NUM_PAGES"] = "num_pages";
  FieldType["SCREENSHOT_PIXELS"] = "screenshot_pixels";
  FieldType["SCREENSHOT_LAYOUT"] = "screenshot_layout";
  FieldType["CSV_ROWS"] = "csv_rows";
  FieldType["CSV_COLUMNS"] = "csv_columns";
  return FieldType;
}({});
/*
 * APM
 */
const REPORTING_TRANSACTION_TYPE = exports.REPORTING_TRANSACTION_TYPE = PLUGIN_ID;

/*
 * Job versioning
 */

// Job params require a `version` field as of 7.15.0. For older jobs set with
// automation that have no version value in the job params, we assume the
// intended version is 7.14.0
const UNVERSIONED_VERSION = exports.UNVERSIONED_VERSION = '7.14.0';