"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeprecationsInfo = void 0;
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingServer = require("@kbn/reporting-server");
var _store = require("../lib/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeprecationsInfo = async ({
  esClient
}) => {
  const ilmPolicyManager = _store.IlmPolicyManager.create({
    client: esClient.asInternalUser
  });
  const migrationStatus = await ilmPolicyManager.checkIlmMigrationStatus();
  if (migrationStatus !== 'ok') {
    return [{
      title: _i18n.i18n.translate('xpack.reporting.deprecations.migrateIndexIlmPolicyActionTitle', {
        defaultMessage: 'Found reporting indices managed by custom ILM policy.'
      }),
      level: 'warning',
      message: _i18n.i18n.translate('xpack.reporting.deprecations.migrateIndexIlmPolicyActionMessage', {
        defaultMessage: `New reporting indices will be managed by the "{reportingIlmPolicy}" provisioned ILM policy. You must edit this policy to manage the report lifecycle. This change targets the hidden system index pattern "{indexPattern}".`,
        values: {
          reportingIlmPolicy: _reportingCommon.ILM_POLICY_NAME,
          indexPattern: _reportingServer.REPORTING_DATA_STREAM_WILDCARD_WITH_LEGACY
        }
      }),
      correctiveActions: {
        manualSteps: [_i18n.i18n.translate('xpack.reporting.deprecations.migrateIndexIlmPolicy.manualStepOneMessage', {
          defaultMessage: 'Update all reporting indices to use the "{reportingIlmPolicy}" policy using the index settings API.',
          values: {
            reportingIlmPolicy: _reportingCommon.ILM_POLICY_NAME
          }
        })],
        api: {
          method: 'PUT',
          path: _reportingCommon.INTERNAL_ROUTES.MIGRATE.MIGRATE_ILM_POLICY
        }
      }
    }];
  }
  return [];
};
exports.getDeprecationsInfo = getDeprecationsInfo;