"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DownloadButton = ({
  getUrl,
  job
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "downloadCompletedReportButton",
    "data-test-jobId": job.id,
    href: getUrl(job.id),
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.publicNotifier.downloadReportButtonLabel",
    defaultMessage: "Download report"
  }));
};
exports.DownloadButton = DownloadButton;