"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SniffConnection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../../services/documentation");
var _validators = require("../validators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SniffConnection = ({
  fields,
  fieldsErrors,
  areErrorsVisible,
  onFieldsChange
}) => {
  const [localSeedErrors, setLocalSeedErrors] = (0, _react.useState)([]);
  const {
    seeds = [],
    nodeConnections
  } = fields;
  const {
    seeds: seedsError,
    nodeConnections: nodeError
  } = fieldsErrors;
  // Show errors if there is a general form error or local errors.
  const areFormErrorsVisible = Boolean(areErrorsVisible && seedsError);
  const showLocalSeedErrors = areFormErrorsVisible || localSeedErrors.length !== 0;
  const errorsInLocalSeeds = areFormErrorsVisible && seedsError ? localSeedErrors.concat(seedsError) : localSeedErrors;
  const formattedSeeds = seeds.map(seed => ({
    label: seed
  }));
  const showNodeConnectionErrors = Boolean(nodeError);
  const onCreateSeed = newSeed => {
    // If the user just hit enter without typing anything, treat it as a no-op.
    if (!newSeed) {
      return;
    }
    const validationErrors = (0, _validators.validateSeed)(newSeed);
    if (validationErrors.length !== 0) {
      setLocalSeedErrors(validationErrors);
      // Return false to explicitly reject the user's input.
      return false;
    }
    const newSeeds = seeds.slice(0);
    newSeeds.push(newSeed.toLowerCase());
    onFieldsChange({
      seeds: newSeeds
    });
  };
  const onSeedsInputChange = seedInput => {
    if (!seedInput) {
      // If empty seedInput ("") don't do anything. This happens
      // right after a seed is created.
      return;
    }

    // Allow typing to clear the errors, but not to add new ones.
    const validationErrors = !seedInput || (0, _validators.validateSeed)(seedInput).length === 0 ? [] : localSeedErrors;

    // EuiComboBox internally checks for duplicates and prevents calling onCreateOption if the
    // input is a duplicate. So we need to surface this error here instead.
    const isDuplicate = seeds.includes(seedInput);
    if (isDuplicate) {
      validationErrors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.localSeedError.duplicateMessage",
        defaultMessage: "Duplicate seed nodes aren't allowed.`"
      }));
    }
    setLocalSeedErrors(validationErrors);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormSeedNodesFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsLabel",
      defaultMessage: "Seed nodes"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsHelpText",
      defaultMessage: "An IP address or host name, followed by the {transportPort} of the remote cluster. Specify multiple seed nodes so discovery doesn't fail if a node is unavailable.",
      values: {
        transportPort: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.transportPortUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.sectionSeedsHelpText.portLinkText",
          defaultMessage: "port"
        }))
      }
    }),
    isInvalid: showLocalSeedErrors,
    error: errorsInLocalSeeds,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldSeedsPlaceholder', {
      defaultMessage: 'host:port'
    }),
    selectedOptions: formattedSeeds,
    onCreateOption: onCreateSeed,
    onChange: options => onFieldsChange({
      seeds: options.map(({
        label
      }) => label)
    }),
    onSearchChange: onSeedsInputChange,
    isInvalid: showLocalSeedErrors,
    fullWidth: true,
    "data-test-subj": "remoteClusterFormSeedsInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormNodeConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsLabel",
      defaultMessage: "Node connections"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsHelpText",
      defaultMessage: "The number of gateway nodes to connect to for this cluster."
    }),
    fullWidth: true,
    isInvalid: showNodeConnectionErrors,
    error: nodeError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: nodeConnections || '',
    onChange: e => onFieldsChange({
      nodeConnections: Number(e.target.value)
    }),
    isInvalid: showNodeConnectionErrors,
    fullWidth: true,
    "data-test-subj": "remoteClusterFormNodeConnectionsInput"
  })));
};
exports.SniffConnection = SniffConnection;