"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SaveError = ({
  saveError
}) => {
  const {
    message,
    cause
  } = saveError;
  const renderErrorBody = () => {
    if (!cause || !Array.isArray(cause)) return null;
    return cause.length === 1 ? /*#__PURE__*/_react.default.createElement("p", null, cause[0]) : /*#__PURE__*/_react.default.createElement("ul", null, cause.map((causeValue, index) => /*#__PURE__*/_react.default.createElement("li", {
      key: index
    }, causeValue)));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: message,
    color: "danger",
    iconType: "error",
    "data-test-subj": "saveErrorBanner"
  }, renderErrorBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.SaveError = SaveError;