"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomBarActions = BottomBarActions;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BottomBarActions({
  isLoading,
  onDiscardChanges,
  onSave,
  unsavedChangesCount,
  saveLabel,
  areChangesInvalid = false
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s",
    "data-test-subj": "profilingBottomBarActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexDirection: 'row',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.bottomBarActions.unsavedChanges', {
    defaultMessage: '{unsavedChangesCount, plural, =0{0 unsaved changes} one {1 unsaved change} other {# unsaved changes}} ',
    values: {
      unsavedChangesCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "profilingBottomBarActionsDiscardChangesButton",
    color: "text",
    onClick: onDiscardChanges
  }, _i18n.i18n.translate('xpack.profiling.bottomBarActions.discardChangesButton', {
    defaultMessage: 'Discard changes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: areChangesInvalid && _i18n.i18n.translate('xpack.profiling.bottomBarActions.saveButtonTooltipWithInvalidChanges', {
      defaultMessage: 'Fix invalid settings before saving.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: areChangesInvalid,
    "data-test-subj": "profilingBottomBarActionsButton",
    onClick: onSave,
    fill: true,
    isLoading: isLoading,
    color: "success",
    iconType: "check"
  }, saveLabel)))))));
}