"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRangeContext = useTimeRangeContext;
var _react = require("react");
var _time_range_context = require("../components/contexts/time_range_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimeRangeContext() {
  const context = (0, _react.useContext)(_time_range_context.TimeRangeContext);
  if (!context) {
    throw new Error('TimeRangeContext was not provided');
  }
  return context;
}