"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackedBarChart = StackedBarChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana_timezone_setting = require("../../hooks/use_kibana_timezone_setting");
var _use_profiling_charts_theme = require("../../hooks/use_profiling_charts_theme");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _subchart = require("../subchart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// 2 * padding (16px)
const MAX_TOOLTIP_WIDTH = 224;
function StackedBarChart({
  height,
  asPercentages,
  onBrushEnd,
  charts,
  showFrames,
  onClick
}) {
  const chartsbyCategoryMap = (0, _react.useMemo)(() => {
    return (0, _lodash.keyBy)(charts, 'Category');
  }, [charts]);
  const timeZone = (0, _use_kibana_timezone_setting.useKibanaTimeZoneSetting)();
  const [highlightedSample, setHighlightedSample] = (0, _react.useState)();
  const {
    chartsBaseTheme,
    chartsTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const CustomTooltipWithSubChart = ({
    header
  }) => {
    if (!highlightedSample) {
      return null;
    }
    const highlightedSubchart = chartsbyCategoryMap[highlightedSample.Category];
    if (!highlightedSubchart) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipHeader, {
      header: header
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
      index: highlightedSubchart.Index,
      color: highlightedSubchart.Color,
      category: highlightedSubchart.Category,
      label: highlightedSubchart.Label,
      data: highlightedSubchart.Series,
      percentage: highlightedSubchart.Percentage,
      sample: highlightedSample,
      showFrames: showFrames,
      height: 128,
      width: MAX_TOOLTIP_WIDTH,
      showAxes: false,
      padTitle: false,
      onClick: onClick ? () => onClick(highlightedSubchart) : undefined
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    brushAxis: _charts.BrushAxis.X,
    onBrushEnd: brushEvent => {
      const rangeFrom = new Date(brushEvent.x[0]).toISOString();
      const rangeTo = new Date(brushEvent.x[1]).toISOString();
      onBrushEnd({
        rangeFrom,
        rangeTo
      });
    },
    baseTheme: chartsBaseTheme,
    theme: chartsTheme,
    onElementOver: events => {
      const [value] = events[0];
      setHighlightedSample(value.datum);
    },
    onElementClick: onClick ? elements => {
      const [value] = elements[0];
      const sample = value.datum;
      onClick(chartsbyCategoryMap[sample.Category]);
    } : undefined,
    onElementOut: () => {
      setHighlightedSample(undefined);
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    customTooltip: CustomTooltipWithSubChart
  }), charts.map(chart => /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    key: chart.Category,
    id: chart.Category,
    name: chart.Label,
    data: chart.Series,
    color: chart.Color,
    xAccessor: 'Timestamp',
    yAccessors: ['Count'],
    stackAccessors: ['true'],
    stackMode: asPercentages ? _charts.StackMode.Percentage : undefined
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    timeZone: timeZone
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: (0, _charts.timeFormatter)('YYYY-MM-DD HH:mm:ss')
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    gridLine: {
      visible: true
    },
    tickFormat: d => asPercentages ? (0, _as_percentage.asPercentage)(d) : d.toFixed(0)
  }));
}