"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitUntilTaskCompleted = exports.isTaskCurrentlyRunningError = exports.getTaskStatus = void 0;
var _server = require("@kbn/core/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTaskStatus = async ({
  taskManager,
  taskId
}) => {
  try {
    const taskInstance = await taskManager.get(taskId);
    return taskInstance.status;
  } catch (e) {
    // not found means the task was completed and the entry removed
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(e)) {
      return 'not_scheduled';
    }
    throw e;
  }
};
exports.getTaskStatus = getTaskStatus;
const isTaskCurrentlyRunningError = err => {
  var _err$message;
  return (_err$message = err.message) === null || _err$message === void 0 ? void 0 : _err$message.includes('currently running');
};
exports.isTaskCurrentlyRunningError = isTaskCurrentlyRunningError;
const waitUntilTaskCompleted = async ({
  taskManager,
  taskId,
  timeout = 120_000,
  interval = 5_000
}) => {
  const start = Date.now();
  const max = start + timeout;
  let now = start;
  while (now < max) {
    try {
      const taskInstance = await taskManager.get(taskId);
      const {
        status
      } = taskInstance;
      if (status === 'idle' || status === 'claiming' || status === 'running') {
        await sleep(interval);
        now = Date.now();
      } else {
        return;
      }
    } catch (e) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        // not found means the task was completed and the entry removed
        return;
      }
    }
  }
  throw new Error(`Timeout waiting for task ${taskId} to complete.`);
};
exports.waitUntilTaskCompleted = waitUntilTaskCompleted;
const sleep = ms => new Promise(resolve => setTimeout(resolve, ms));