"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleEnsureUpToDateTask = exports.registerEnsureUpToDateTaskDefinition = exports.ENSURE_DOC_UP_TO_DATE_TASK_TYPE = exports.ENSURE_DOC_UP_TO_DATE_TASK_ID_MULTILINGUAL = exports.ENSURE_DOC_UP_TO_DATE_TASK_ID = void 0;
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENSURE_DOC_UP_TO_DATE_TASK_TYPE = exports.ENSURE_DOC_UP_TO_DATE_TASK_TYPE = 'ProductDocBase:EnsureUpToDate';
const ENSURE_DOC_UP_TO_DATE_TASK_ID = exports.ENSURE_DOC_UP_TO_DATE_TASK_ID = 'ProductDocBase:EnsureUpToDate';
const ENSURE_DOC_UP_TO_DATE_TASK_ID_MULTILINGUAL = exports.ENSURE_DOC_UP_TO_DATE_TASK_ID_MULTILINGUAL = 'ProductDocBase:EnsureUpToDateMultilingual';
const registerEnsureUpToDateTaskDefinition = ({
  getServices,
  taskManager
}) => {
  taskManager.registerTaskDefinitions({
    [ENSURE_DOC_UP_TO_DATE_TASK_TYPE]: {
      title: 'Ensure product documentation up to date task',
      timeout: '10m',
      maxAttempts: 3,
      createTaskRunner: context => {
        return {
          async run() {
            var _context$taskInstance, _context$taskInstance2;
            const inferenceId = (_context$taskInstance = context.taskInstance) === null || _context$taskInstance === void 0 ? void 0 : (_context$taskInstance2 = _context$taskInstance.params) === null || _context$taskInstance2 === void 0 ? void 0 : _context$taskInstance2.inferenceId;
            const {
              packageInstaller
            } = getServices();
            return packageInstaller.ensureUpToDate({
              inferenceId
            });
          }
        };
      },
      stateSchemaByVersion: {}
    }
  });
};
exports.registerEnsureUpToDateTaskDefinition = registerEnsureUpToDateTaskDefinition;
const scheduleEnsureUpToDateTask = async ({
  taskManager,
  logger,
  inferenceId
}) => {
  const taskId = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? ENSURE_DOC_UP_TO_DATE_TASK_ID : ENSURE_DOC_UP_TO_DATE_TASK_ID_MULTILINGUAL;
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: ENSURE_DOC_UP_TO_DATE_TASK_TYPE,
      params: {
        inferenceId
      },
      state: {},
      scope: ['productDoc']
    });
    await taskManager.runSoon(taskId);
    logger.info(`Task ${taskId} scheduled to run soon`);
  } catch (e) {
    if (!(0, _utils.isTaskCurrentlyRunningError)(e)) {
      throw e;
    }
  }
  return taskId;
};
exports.scheduleEnsureUpToDateTask = scheduleEnsureUpToDateTask;