"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocInstallClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _productDocCommon = require("@kbn/product-doc-common");
var _inferenceCommon = require("@kbn/inference-common");
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _consts = require("../../../common/consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductDocInstallClient {
  constructor({
    soClient,
    log
  }) {
    (0, _defineProperty2.default)(this, "soClient", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.soClient = soClient;
    this.log = log;
  }
  async getPreviouslyInstalledInferenceIds() {
    const query = {
      type: _consts.productDocInstallStatusSavedObjectTypeName,
      perPage: 100
    };
    const response = await this.soClient.find(query);
    const inferenceIds = new Set(response === null || response === void 0 ? void 0 : response.saved_objects.map(so => {
      var _so$attributes$infere, _so$attributes;
      return (_so$attributes$infere = (_so$attributes = so.attributes) === null || _so$attributes === void 0 ? void 0 : _so$attributes.inference_id) !== null && _so$attributes$infere !== void 0 ? _so$attributes$infere : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    }));
    return Array.from(inferenceIds);
  }
  async getInstallationStatus({
    inferenceId
  }) {
    const query = {
      type: _consts.productDocInstallStatusSavedObjectTypeName,
      perPage: 100
    };
    const installStatus = Object.values(_productDocCommon.DocumentationProduct).reduce((memo, product) => {
      memo[product] = {
        status: 'uninstalled'
      };
      return memo;
    }, {});
    try {
      const response = await this.soClient.find(query);
      const savedObjects = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(so.attributes.inference_id)) : response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => so.attributes.inference_id === inferenceId);
      savedObjects === null || savedObjects === void 0 ? void 0 : savedObjects.forEach(({
        attributes
      }) => {
        installStatus[attributes.product_name] = {
          status: attributes.installation_status,
          version: attributes.product_version,
          ...(attributes.last_installation_failure_reason ? {
            failureReason: attributes.last_installation_failure_reason
          } : {})
        };
      });
      return installStatus;
    } catch (error) {
      this.log.error(`An error occurred getting installation status saved object for inferenceId [${inferenceId}]
        Query: ${JSON.stringify(query, null, 2)}`, error);
      return installStatus;
    }
  }
  async setInstallationStarted(fields) {
    const {
      productName,
      productVersion,
      inferenceId
    } = fields;
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    const attributes = {
      product_name: productName,
      product_version: productVersion,
      installation_status: 'installing',
      last_installation_failure_reason: '',
      inference_id: inferenceId
    };
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, attributes, {
      upsert: attributes
    });
  }
  async setUninstallationStarted(productName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'uninstalling',
      inference_id: inferenceId
    });
  }
  async setInstallationSuccessful(productName, indexName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'installed',
      index_name: indexName,
      inference_id: inferenceId
    });
  }
  async setInstallationFailed(productName, failureReason, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'error',
      last_installation_failure_reason: failureReason,
      inference_id: inferenceId
    });
  }
  async setUninstalled(productName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    try {
      await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
        installation_status: 'uninstalled',
        last_installation_failure_reason: '',
        inference_id: inferenceId
      });
    } catch (e) {
      if (!_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        throw e;
      }
    }
  }
}
exports.ProductDocInstallClient = ProductDocInstallClient;
const getObjectIdFromProductName = (productName, inferenceId) => {
  const inferenceIdPart = !(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : '';
  return `kb-product-doc-${productName}${inferenceIdPart}-status`.toLowerCase();
};