"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("../../i18n");
var _get_presentation_capabilities = require("../../utils/get_presentation_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  Switch: strings
} = _i18n.LabsStrings.Components;
const switchText = {
  kibana: strings.getKibanaSwitchText(),
  browser: strings.getBrowserSwitchText(),
  session: strings.getSessionSwitchText()
};
const EnvironmentSwitch = ({
  env,
  isChecked,
  onChange,
  name
}) => {
  const {
    canSetAdvancedSettings
  } = (0, _react.useMemo)(() => {
    return (0, _get_presentation_capabilities.getPresentationCapabilities)();
  }, []);
  const canSet = env === 'kibana' ? canSetAdvancedSettings : true;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginBottom: '.25rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: !canSet,
    checked: isChecked,
    css: {
      marginTop: 1
    },
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, name, " - ")), switchText[env].name),
    onChange: e => onChange(e.target.checked),
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: switchText[env].help,
    position: "left"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
};
exports.EnvironmentSwitch = EnvironmentSwitch;