"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovePanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationContainers.getContainerParentFromAPI)(api));
class RemovePanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_REMOVE_PANEL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_REMOVE_PANEL);
    (0, _defineProperty2.default)(this, "order", 0);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: 'remove_panel_group',
      order: 1
    }]);
  }
  getDisplayName() {
    return _i18n.i18n.translate('presentationPanel.action.removePanel.displayName', {
      defaultMessage: 'Remove'
    });
  }
  getIconType() {
    return 'trash';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$parentApi, _embeddable$parentApi2, _embeddable$parentApi3;
    if (!isApiCompatible(embeddable)) return false;

    // any parent can disallow panel removal by implementing canRemovePanels. If this method
    // is not implemented, panel removal is always allowed.
    const parentAllowsPanelRemoval = (_embeddable$parentApi = (_embeddable$parentApi2 = (_embeddable$parentApi3 = embeddable.parentApi).canRemovePanels) === null || _embeddable$parentApi2 === void 0 ? void 0 : _embeddable$parentApi2.call(_embeddable$parentApi3)) !== null && _embeddable$parentApi !== void 0 ? _embeddable$parentApi : true;
    return Boolean((0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && parentAllowsPanelRemoval);
  }
  async execute({
    embeddable
  }) {
    var _embeddable$parentApi4;
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    (_embeddable$parentApi4 = embeddable.parentApi) === null || _embeddable$parentApi4 === void 0 ? void 0 : _embeddable$parentApi4.removePanel(embeddable.uuid);
  }
}
exports.RemovePanelAction = RemovePanelAction;