"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersDetails = FiltersDetails;
exports.filterDetailsActionStrings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/unified-search-plugin/public");
var _execute_edit_action = require("../edit_panel_action/execute_edit_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const filterDetailsActionStrings = exports.filterDetailsActionStrings = {
  getQueryTitle: () => _i18n.i18n.translate('presentationPanel.filters.queryTitle', {
    defaultMessage: 'Query'
  }),
  getFiltersTitle: () => _i18n.i18n.translate('presentationPanel.filters.filtersTitle', {
    defaultMessage: 'Filters'
  })
};
function FiltersDetails({
  editMode,
  api
}) {
  var _api$dataViews$$value, _api$dataViews$;
  const [queryString, setQueryString] = (0, _react.useState)('');
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)();
  const dataViews = (_api$dataViews$$value = (_api$dataViews$ = api.dataViews$) === null || _api$dataViews$ === void 0 ? void 0 : _api$dataViews$.value) !== null && _api$dataViews$$value !== void 0 ? _api$dataViews$$value : [];
  const filters = (0, _react.useMemo)(() => {
    var _api$filters$$value, _api$filters$;
    return (_api$filters$$value = (_api$filters$ = api.filters$) === null || _api$filters$ === void 0 ? void 0 : _api$filters$.value) !== null && _api$filters$$value !== void 0 ? _api$filters$$value : [];
  }, [api]);
  const [incompatibleQueryLanguage, setIncompatibleQueryLanguage] = (0, _react.useState)(false);
  const showEditButton = (0, _presentationPublishing.hasEditCapabilities)(api) && editMode && !incompatibleQueryLanguage;
  (0, _useMount.default)(() => {
    var _api$query$;
    const localQuery = (_api$query$ = api.query$) === null || _api$query$ === void 0 ? void 0 : _api$query$.value;
    if (localQuery) {
      if ((0, _esQuery.isOfQueryType)(localQuery)) {
        if (typeof localQuery.query === 'string') {
          setQueryString(localQuery.query);
        } else {
          setQueryString(JSON.stringify(localQuery.query, null, 2));
        }
      } else {
        const language = (0, _esQuery.getAggregateQueryMode)(localQuery);
        setQueryLanguage(language);
        setQueryString(localQuery[language]);
        setIncompatibleQueryLanguage(true);
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, queryString !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "panelCustomQueryRow",
    label: filterDetailsActionStrings.getQueryTitle(),
    display: "rowCompressed",
    labelAppend: showEditButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "customizePanelEditQueryButton",
      onClick: () => (0, _execute_edit_action.executeEditPanelAction)(api),
      "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.editQueryButtonAriaLabel', {
        defaultMessage: 'Edit query'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.editQueryButtonLabel",
      defaultMessage: "Edit"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "customPanelQuery",
    language: queryLanguage,
    paddingSize: "s",
    fontSize: "s",
    "aria-labelledby": `${filterDetailsActionStrings.getQueryTitle()}: ${queryString}`,
    tabIndex: 0 // focus so that keyboard controls will not skip over the code block
  }, queryString)), filters.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "panelCustomFiltersRow",
    label: filterDetailsActionStrings.getFiltersTitle(),
    labelAppend: showEditButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "customizePanelEditFiltersButton",
      onClick: () => (0, _execute_edit_action.executeEditPanelAction)(api),
      "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.editFiltersButtonAriaLabel', {
        defaultMessage: 'Edit filters'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.editFiltersButtonLabel",
      defaultMessage: "Edit"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public.FilterItems, {
    filters: filters,
    indexPatterns: dataViews,
    readOnly: true
  }))));
}