"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PainlessLabUIPlugin = void 0;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _links = require("./links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const checkLicenseStatus = license => {
  const {
    state,
    message
  } = license.check(_constants.PLUGIN.id, _constants.PLUGIN.minimumLicenseType);
  return state === 'valid' ? {
    valid: true
  } : {
    valid: false,
    message
  };
};
class PainlessLabUIPlugin {
  setup({
    http,
    getStartServices,
    uiSettings
  }, {
    devTools,
    home,
    licensing
  }) {
    home.featureCatalogue.register({
      id: _constants.PLUGIN.id,
      title: _i18n.i18n.translate('xpack.painlessLab.registryProviderTitle', {
        defaultMessage: 'Painless Lab (beta)'
      }),
      description: _i18n.i18n.translate('xpack.painlessLab.registryProviderDescription', {
        defaultMessage: 'Simulate and debug painless code.'
      }),
      icon: 'empty',
      path: '/app/dev_tools#/painless_lab',
      showOnHomePage: false,
      category: 'admin'
    });
    const devTool = devTools.register({
      id: 'painless_lab',
      order: 7,
      isBeta: true,
      title: _i18n.i18n.translate('xpack.painlessLab.displayName', {
        defaultMessage: 'Painless Lab'
      }),
      enableRouting: false,
      disabled: false,
      mount: async ({
        element
      }) => {
        const [core] = await getStartServices();
        const {
          notifications,
          docLinks,
          chrome,
          settings,
          ...startServices
        } = core;
        const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
        const licenseStatus = checkLicenseStatus(license);
        if (!licenseStatus.valid) {
          notifications.toasts.addDanger(licenseStatus.message);
          window.location.hash = '/dev_tools';
          return () => {};
        }
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const tearDownApp = renderApp(element, {
          http,
          uiSettings,
          links: (0, _links.getLinks)(docLinks),
          chrome,
          settings,
          startServices
        });
        return () => {
          tearDownApp();
        };
      }
    });
    licensing.license$.subscribe(license => {
      if (!checkLicenseStatus(license).valid && !devTool.isDisabled()) {
        devTool.disable();
      } else if (devTool.isDisabled()) {
        devTool.enable();
      }
    });
  }
  start() {}
  stop() {}
}
exports.PainlessLabUIPlugin = PainlessLabUIPlugin;