"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MainControls = MainControls;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MainControls({
  toggleRequestFlyout,
  isRequestFlyoutOpen,
  reset,
  links
}) {
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "walkthrough",
    icon: "popout",
    href: links.painlessWalkthrough,
    target: "_blank",
    onClick: () => setIsHelpOpen(false)
  }, _i18n.i18n.translate('xpack.painlessLab.walkthroughButtonLabel', {
    defaultMessage: 'Walkthrough'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "api",
    icon: "popout",
    href: links.painlessAPIReference,
    target: "_blank",
    onClick: () => setIsHelpOpen(false)
  }, _i18n.i18n.translate('xpack.painlessLab.apiReferenceButtonLabel', {
    defaultMessage: 'API reference'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "languageSpec",
    icon: "popout",
    href: links.painlessLangSpec,
    target: "_blank",
    onClick: () => setIsHelpOpen(false)
  }, _i18n.i18n.translate('xpack.painlessLab.languageSpecButtonLabel', {
    defaultMessage: 'Language spec'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "reset",
    icon: "bolt",
    onClick: () => {
      reset();
      setIsHelpOpen(false);
    }
  }, _i18n.i18n.translate('xpack.painlessLab.resetButtonLabel', {
    defaultMessage: 'Reset script'
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "painlessLabHelpContextMenu",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "question",
      iconSide: "left",
      color: "text",
      onClick: () => setIsHelpOpen(!isHelpOpen)
    }, _i18n.i18n.translate('xpack.painlessLab.helpButtonLabel', {
      defaultMessage: 'Help'
    })),
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "upLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: toggleRequestFlyout,
    "data-test-subj": "btnViewRequest"
  }, isRequestFlyoutOpen ? _i18n.i18n.translate('xpack.painlessLab.hideRequestButtonLabel', {
    defaultMessage: 'Hide API request'
  }) : _i18n.i18n.translate('xpack.painlessLab.showRequestButtonLabel', {
    defaultMessage: 'Show API request'
  })))));
}