"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryManagedCustomButtonExtension = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _navigation_buttons = require("./navigation_buttons");
var _disabled_callout = require("./disabled_callout");
var _missing_privileges = require("../routes/components/missing_privileges");
var _use_fetch_status = require("./use_fetch_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Osquery-specific package policy instructions
 * for use in the Fleet app custom tab
 */
const OsqueryManagedCustomButtonExtension = exports.OsqueryManagedCustomButtonExtension = /*#__PURE__*/_react.default.memo(() => {
  const {
    loading,
    disabled,
    permissionDenied
  } = (0, _use_fetch_status.useFetchStatus)();
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 5
    });
  }
  if (permissionDenied) {
    return /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivileges, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, disabled ? /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, null) : null, /*#__PURE__*/_react.default.createElement(_navigation_buttons.NavigationButtons, {
    isDisabled: disabled
  }));
});
OsqueryManagedCustomButtonExtension.displayName = 'OsqueryManagedCustomButtonExtension';