"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlamegraphLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FlamegraphLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", 'flamegraphLocator');
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      kuery
    }) => {
      const params = {
        rangeFrom,
        rangeTo,
        kuery
      };
      return {
        app: 'profiling',
        path: `/flamegraphs/flamegraph?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.FlamegraphLocatorDefinition = FlamegraphLocatorDefinition;