"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relevantPanelSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const relevantPanelSchema = exports.relevantPanelSchema = _zod.z.object({
  panel: _zod.z.object({
    panelIndex: _zod.z.string(),
    type: _zod.z.string(),
    panelConfig: _zod.z.record(_zod.z.string(), _zod.z.any()),
    title: _zod.z.string().optional()
  }),
  matchedBy: _zod.z.object({
    fields: _zod.z.array(_zod.z.string()).optional(),
    index: _zod.z.array(_zod.z.string()).optional()
  })
});