"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateAlertsClient = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alert_not_found_error = require("../common/errors/alert_not_found_error");
var _alert_data = require("./alert_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InvestigateAlertsClient {
  constructor(alertsClient, rulesClient) {
    this.alertsClient = alertsClient;
    this.rulesClient = rulesClient;
  }
  async getAlertById(alertId) {
    const indices = (await this.getAlertsIndices()) || [];
    if (!indices.length) {
      throw new Error('No alert indices exist');
    }
    try {
      const alert = await this.alertsClient.get({
        id: alertId,
        index: indices.join(',')
      });
      return new _alert_data.AlertData(alert);
    } catch (e) {
      if (e.output.payload.statusCode === 404) {
        throw new _alert_not_found_error.AlertNotFoundError(`Alert with id ${alertId} not found`);
      }
      throw e;
    }
  }
  async getRuleById(ruleId) {
    return await this.rulesClient.get({
      id: ruleId
    });
  }
  async getAlertsIndices() {
    return await this.alertsClient.getAuthorizedAlertsIndices([..._ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS, ..._ruleDataUtils.STACK_RULE_TYPE_IDS_SUPPORTED_BY_OBSERVABILITY]);
  }
}
exports.InvestigateAlertsClient = InvestigateAlertsClient;