"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cases = Cases;
var _react = _interopRequireWildcard(require("react"));
var _alerts_flyout = _interopRequireDefault(require("../../../components/alerts_flyout/alerts_flyout"));
var _common = require("../../../../common");
var _kibana_react = require("../../../utils/kibana_react");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../../hooks/use_fetch_alert_detail");
var _use_fetch_alert_data = require("../../../hooks/use_fetch_alert_data");
var _ = require("../../..");
var _paths = require("../../../../common/locators/paths");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Cases({
  permissions
}) {
  const {
    application: {
      navigateToUrl
    },
    cases: {
      ui: {
        getCases: CasesList
      }
    },
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const [selectedAlertId, setSelectedAlertId] = (0, _react.useState)('');
  const [alertLoading, alertDetail] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(selectedAlertId);
  const handleFlyoutClose = () => setSelectedAlertId('');
  const handleShowAlertDetails = alertId => {
    setSelectedAlertId(alertId);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CasesList, {
    basePath: _paths.CASES_PATH,
    features: {
      alerts: {
        sync: false,
        isExperimental: false
      },
      observables: {
        enabled: false
      }
    },
    owner: [_common.observabilityFeatureId],
    permissions: permissions,
    ruleDetailsNavigation: {
      href: ruleId => prepend(_paths.paths.observability.ruleDetails(ruleId || '')),
      onClick: (ruleId, ev) => {
        const ruleLink = prepend(_paths.paths.observability.ruleDetails(ruleId || ''));
        if (ev != null) {
          ev.preventDefault();
        }
        return navigateToUrl(ruleLink);
      }
    },
    showAlertDetails: handleShowAlertDetails,
    useFetchAlertData: _use_fetch_alert_data.useFetchAlertData,
    renderAlertsTable: props => /*#__PURE__*/_react.default.createElement(_.ObservabilityAlertsTable, props)
  }), alertDetail && selectedAlertId !== '' && !alertLoading ? /*#__PURE__*/_react.default.createElement(_alerts_flyout.default, {
    alert: alertDetail.raw,
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry,
    onClose: handleFlyoutClose
  }) : null);
}